/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXDataTemplate;
import com.portalmedia.embarc.system.UserPreferencesService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;

public class DataTemplateDialog
extends Dialog {
    @FXML
    private TextField nameField;
    @FXML
    private Label dateCreated;
    @FXML
    private ChoiceBox<DPXColumn> columnChoiceBox;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    @FXML
    private Button deleteTemplateButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button cancelButton;
    @FXML
    private TextField valueField;
    @FXML
    private Pane listPane;
    Stage dataTemplateStage;
    ObservableList<DPXColumn> columnList;
    ListView<String> listView = new ListView();
    ObservableMap<DPXColumn, String> backingMap = FXCollections.observableHashMap();
    ObservableMap<DPXColumn, String> setMap = FXCollections.observableHashMap();
    DPXDataTemplate template;
    final UserPreferencesService userPreferences = new UserPreferencesService();
    ValidationSupport validationSupport = new ValidationSupport();

    public DataTemplateDialog() {
        this.template = new DPXDataTemplate();
        this.template.setValues(new HashMap<DPXColumn, String>());
        this.template.setName("");
        this.createDataTemplateStage();
        this.dataTemplateStage.setTitle("Create Data Template");
    }

    public DataTemplateDialog(DPXDataTemplate savedTemplate) {
        this.template = savedTemplate;
        this.createDataTemplateStage();
        this.dataTemplateStage.setTitle("Edit Data Template");
    }

    public void createDataTemplateStage() {
        this.dataTemplateStage = new Stage();
        this.dataTemplateStage.initOwner((Window)Main.getPrimaryStage());
        this.dataTemplateStage.setHeight(450.0);
        this.dataTemplateStage.setWidth(610.0);
        this.dataTemplateStage.initStyle(StageStyle.UTILITY);
        this.dataTemplateStage.setResizable(false);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("DPXDataTemplate.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            Scene scene = new Scene((Parent)fxmlLoader.load());
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
            this.setContent();
            this.dataTemplateStage.setScene(scene);
            this.dataTemplateStage.show();
        }
        catch (IOException e) {
            System.out.println("Error creating data template stage");
        }
    }

    public void setContent() {
        this.setMap.putAll(this.template.getValues());
        this.removeButton.setVisible(false);
        for (Map.Entry entry : this.setMap.entrySet()) {
            this.backingMap.put((Object)((DPXColumn)entry.getKey()), (Object)(((DPXColumn)entry.getKey()).getDisplayName() + ": " + (String)entry.getValue()));
        }
        this.setMap.addListener(change -> {
            if (change.wasRemoved()) {
                this.backingMap.remove(change.getKey());
            }
            if (change.wasAdded()) {
                this.backingMap.put((Object)((DPXColumn)change.getKey()), (Object)(((DPXColumn)change.getKey()).getDisplayName() + ": " + (String)change.getValueAdded()));
            }
        });
        this.listView.getItems().setAll(this.backingMap.values());
        this.listView.setPrefHeight(194.0);
        this.listView.setPrefWidth(560.0);
        MultipleSelectionModel listSelection = this.listView.getSelectionModel();
        listSelection.selectedItemProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null) {
                    DataTemplateDialog.this.removeButton.setVisible(true);
                } else {
                    DataTemplateDialog.this.removeButton.setVisible(false);
                }
            }
        });
        this.listPane.getChildren().add(0, this.listView);
        if (!this.template.getName().isEmpty()) {
            this.nameField.setText(this.template.getName());
            this.nameField.setDisable(true);
            this.deleteTemplateButton.setVisible(true);
        } else {
            this.deleteTemplateButton.setVisible(false);
            this.validationSupport.setErrorDecorationEnabled(false);
            this.validationSupport.registerValidator((Control)this.nameField, Validator.createEmptyValidator((String)"Data template name is required"));
        }
        this.dateCreated.setText(this.template.getInsertDate().toString());
        this.addButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DPXColumn col = (DPXColumn)DataTemplateDialog.this.columnChoiceBox.getValue();
                String val = DataTemplateDialog.this.valueField.getText();
                if (val.isEmpty()) {
                    return;
                }
                DataTemplateDialog.this.setMap.put((Object)col, (Object)val);
                DataTemplateDialog.this.listView.getItems().setAll(DataTemplateDialog.this.backingMap.values());
                DataTemplateDialog.this.valueField.clear();
            }
        });
        this.removeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){
            final /* synthetic */ SelectionModel val$listSelection;
            {
                this.val$listSelection = selectionModel;
            }

            public void handle(ActionEvent e) {
                String selected = (String)this.val$listSelection.getSelectedItem();
                if (DataTemplateDialog.this.backingMap.containsValue((Object)selected)) {
                    ColumnDef toRemove = null;
                    for (Map.Entry entry : DataTemplateDialog.this.backingMap.entrySet()) {
                        if (!Objects.equals(selected, entry.getValue())) continue;
                        toRemove = (ColumnDef)entry.getKey();
                    }
                    if (toRemove != null) {
                        DataTemplateDialog.this.setMap.remove(toRemove);
                        DataTemplateDialog.this.listView.getItems().setAll(DataTemplateDialog.this.backingMap.values());
                    }
                }
            }
        });
        this.deleteTemplateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                String message = "Are you sure you want to delete this template?";
                Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Delete Template", Alert.AlertType.CONFIRMATION, "Are you sure you want to delete this template?", new ButtonType[0]);
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.initOwner((Window)Main.getPrimaryStage());
                alert.setGraphic(null);
                alert.setHeaderText(null);
                DialogPane dialogPane = alert.getDialogPane();
                dialogPane.lookupButton(ButtonType.OK).setAccessibleHelp("Are you sure you want to delete this template?");
                dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
                dialogPane.getStyleClass().add((Object)"alertDialog");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    DataTemplateDialog.this.userPreferences.removeDpxDataTemplate(DataTemplateDialog.this.template.getName());
                    DataTemplateDialog.this.dataTemplateStage.close();
                    ControllerMediatorDPX.getInstance().refreshDataTemplateList();
                } else {
                    e.consume();
                }
            }
        });
        this.saveButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DataTemplateDialog.this.validationSupport.setErrorDecorationEnabled(true);
                if (DataTemplateDialog.this.nameField.getText().isEmpty()) {
                    return;
                }
                DataTemplateDialog.this.template.setName(DataTemplateDialog.this.nameField.getText());
                HashMap<DPXColumn, String> map = new HashMap<DPXColumn, String>((Map<DPXColumn, String>)DataTemplateDialog.this.setMap);
                DataTemplateDialog.this.template.setValues(map);
                DataTemplateDialog.this.userPreferences.addDpxDataTemplate(DataTemplateDialog.this.template);
                DataTemplateDialog.this.dataTemplateStage.close();
                ControllerMediatorDPX.getInstance().refreshDataTemplateList();
            }
        });
        this.cancelButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DataTemplateDialog.this.dataTemplateStage.close();
            }
        });
        this.columnList = FXCollections.observableArrayList();
        for (DPXColumn c : DPXColumn.values()) {
            if (!c.getEditable()) continue;
            this.columnList.add((Object)c);
        }
        this.columnChoiceBox.getItems().addAll(this.columnList);
    }
}

