/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.Main;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ProgressSpinner {
    private final Stage dialogStage;
    private final ProgressIndicator progressIndicator = new ProgressIndicator();
    private final VBox vbox;
    private final GridPane grid;

    public ProgressSpinner() {
        this.dialogStage = new Stage();
        this.dialogStage.initOwner((Window)Main.getPrimaryStage());
        this.dialogStage.setHeight(90.0);
        this.dialogStage.setWidth(100.0);
        this.dialogStage.setResizable(false);
        this.dialogStage.initModality(Modality.APPLICATION_MODAL);
        this.dialogStage.initStyle(StageStyle.UNDECORATED);
        this.progressIndicator.setProgress(-1.0);
        this.grid = new GridPane();
        this.grid.setPrefWidth(90.0);
        this.grid.setVgap(15.0);
        this.grid.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        this.grid.setAlignment(Pos.CENTER);
        this.grid.add((Node)new Label("Working..."), 0, 0);
        this.grid.add((Node)this.progressIndicator, 0, 1);
        this.vbox = new VBox();
        this.vbox.setAlignment(Pos.TOP_CENTER);
        this.vbox.getChildren().add((Object)this.grid);
        Scene scene = new Scene((Parent)this.vbox);
        this.dialogStage.setScene(scene);
    }

    public void activateProgressBar(Task<?> task) {
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.dialogStage.show();
    }

    public Stage getDialogStage() {
        return this.dialogStage;
    }
}

