/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidIntRangeRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic Int Range Rule";
    long min;
    long max;

    public IsValidIntRangeRule(int min, int max) {
        this.min = min & 0xFF;
        this.max = max & 0xFF;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    @Override
    public boolean isValid(String value) {
        if (value.length() == 0) {
            return true;
        }
        try {
            long v = Long.parseLong(value);
            if (v >= this.min && v <= this.max && v >= 0L) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setMin(((Short)document.get("min")).shortValue());
            this.setMax(((Short)document.get("max")).shortValue());
        }
    }

    public void setMax(long max) {
        this.max = max;
    }

    public void setMin(long min) {
        this.min = min;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("min", (Object)this.getMin());
        document.put("max", (Object)this.getMax());
        return document;
    }
}

