/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.dpx;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import java.io.Serializable;
import java.util.LinkedList;

public enum DPXSection implements Serializable,
SectionDef
{
    FILE_INFORMATION_HEADER("File Information"),
    IMAGE_INFORMATION_HEADER("Image Information"),
    IMAGE_SOURCE_INFORMATION_HEADER("Image Source Information"),
    MOTION_PICTURE_FILM_INFORMATION_HEADER("Motion Picture Film Information"),
    TELEVISION_INFORMATION_HEADER("Television Information"),
    USER_DEFINED_DATA("User Defined Information");

    private String displayName;

    @JsonCreator
    private DPXSection(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public LinkedList<DPXColumn> getColumns() {
        LinkedList<DPXColumn> toReturn = new LinkedList<DPXColumn>();
        for (DPXColumn column : DPXColumn.values()) {
            if (column.getSection() != this) continue;
            toReturn.add(column);
        }
        return toReturn;
    }

    @Override
    public LinkedList<MXFColumn> getColumnsMXF() {
        return null;
    }
}

