/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.model.DatabaseSummary;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.IOException;
import java.util.HashSet;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class WriteFilesView
extends AnchorPane {
    @FXML
    private AnchorPane writeFilesSummaryPane;
    private CheckBox smptcCB;
    private CheckBox fsrCB;
    private CheckBox frCB;
    private CheckBox foCB;

    public WriteFilesView() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("WriteFilesView.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        ControllerMediatorDPX.getInstance().registerWriteFilesView(this);
        this.smptcCB = new CheckBox();
        this.fsrCB = new CheckBox();
        this.frCB = new CheckBox();
        this.foCB = new CheckBox();
        this.resetValidationRuleIndicators();
    }

    public void resetValidationRuleIndicators() {
        HashSet<ValidationRuleSetEnum> selectedRules = ControllerMediatorDPX.getInstance().getCurrentRuleSets();
        if (selectedRules.contains((Object)ValidationRuleSetEnum.SMPTE_C)) {
            this.smptcCB.setSelected(true);
        } else {
            this.smptcCB.setSelected(false);
        }
        if (selectedRules.contains((Object)ValidationRuleSetEnum.FADGI_SR)) {
            this.fsrCB.setSelected(true);
        } else {
            this.fsrCB.setSelected(false);
        }
        if (selectedRules.contains((Object)ValidationRuleSetEnum.FADGI_R)) {
            this.frCB.setSelected(true);
        } else {
            this.frCB.setSelected(false);
        }
        if (selectedRules.contains((Object)ValidationRuleSetEnum.FADGI_O)) {
            this.foCB.setSelected(true);
        } else {
            this.foCB.setSelected(false);
        }
    }

    public void setMessage(SectionDef section) {
        VBox container = new VBox();
        AnchorPane.setTopAnchor((Node)container, (Double)0.0);
        AnchorPane.setRightAnchor((Node)container, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)container, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)container, (Double)0.0);
        this.writeFilesSummaryPane.getChildren().add((Object)container);
        VBox headerBox = new VBox();
        headerBox.getStyleClass().add((Object)"editor-header-box");
        headerBox.setSpacing(10.0);
        AnchorPane.setTopAnchor((Node)headerBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)headerBox, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)headerBox, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)headerBox, (Double)0.0);
        Label l1 = new Label("File Summary");
        l1.setFocusTraversable(true);
        l1.getStyleClass().add((Object)"editor-header");
        headerBox.getChildren().add((Object)l1);
        Label l2 = new Label("Select one or more files to view and edit data");
        l2.setFocusTraversable(true);
        l2.getStyleClass().add((Object)"editor-header-selected-files-label");
        headerBox.getChildren().add((Object)l2);
        HBox gridBox = new HBox();
        gridBox.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
        GridPane grid = new GridPane();
        gridBox.getChildren().add((Object)grid);
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        container.getChildren().addAll((Object[])new Node[]{headerBox, gridBox});
        Label totalFilesLabel = new Label("Total Files:");
        grid.add((Node)totalFilesLabel, 0, 0);
        Label totalFilesText = new Label(String.valueOf(DatabaseSummary.getFileCount()));
        grid.add((Node)totalFilesText, 1, 0);
        totalFilesLabel.setAccessibleText(totalFilesText.getText() + " total files");
        totalFilesLabel.setFocusTraversable(true);
        this.smptcCB.setId("SMPTE_C");
        Label smptcLabel = new Label("Files with SMPTE-C Violations");
        smptcLabel.setLabelFor((Node)this.smptcCB);
        FontIcon icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
        icon.getStyleClass().add((Object)"smpte-c-warning");
        icon.setIconSize(18);
        smptcLabel.setGraphic((Node)icon);
        HBox smptcHBox = new HBox();
        smptcHBox.setSpacing(10.0);
        smptcHBox.getChildren().add((Object)this.smptcCB);
        smptcHBox.getChildren().add((Object)smptcLabel);
        grid.add((Node)smptcHBox, 0, 1);
        int smptcErrors = DatabaseSummary.getErrorCount(ValidationRuleSetEnum.SMPTE_C);
        grid.add((Node)new Label(String.valueOf(smptcErrors)), 1, 1);
        smptcLabel.setAccessibleText(smptcErrors + " files with SMPTE-C Violations.");
        this.smptcCB.setOnAction(event -> this.handleCheckboxEvent((ActionEvent)event));
        this.fsrCB.setId("FADGI_SR");
        Label fsrLabel = new Label("Files with FADGI-SR violations");
        fsrLabel.setLabelFor((Node)this.fsrCB);
        FontIcon icon1 = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
        icon1.getStyleClass().add((Object)"fadgi-sr-warning");
        icon1.setIconSize(18);
        fsrLabel.setGraphic((Node)icon1);
        HBox fsrHBox = new HBox();
        fsrHBox.setSpacing(10.0);
        fsrHBox.getChildren().add((Object)this.fsrCB);
        fsrHBox.getChildren().add((Object)fsrLabel);
        grid.add((Node)fsrHBox, 0, 2);
        int fsrErrors = DatabaseSummary.getErrorCount(ValidationRuleSetEnum.FADGI_SR);
        grid.add((Node)new Label(String.valueOf(fsrErrors)), 1, 2);
        fsrLabel.setAccessibleText(fsrErrors + " files with FADGI-SR violations.");
        this.fsrCB.setOnAction(event -> this.handleCheckboxEvent((ActionEvent)event));
        this.frCB.setId("FADGI_R");
        Label frLabel = new Label("Files with FADGI-R Violations");
        frLabel.setLabelFor((Node)this.frCB);
        FontIcon icon2 = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
        icon2.getStyleClass().add((Object)"fadgi-r-warning");
        icon2.setIconSize(16);
        frLabel.setGraphic((Node)icon2);
        HBox frHBox = new HBox();
        frHBox.setSpacing(10.0);
        frHBox.getChildren().add((Object)this.frCB);
        frHBox.getChildren().add((Object)frLabel);
        grid.add((Node)frHBox, 0, 3);
        int frErrors = DatabaseSummary.getErrorCount(ValidationRuleSetEnum.FADGI_R);
        grid.add((Node)new Label(String.valueOf(frErrors)), 1, 3);
        frLabel.setAccessibleText(frErrors + " files with FADGI-R violations.");
        this.frCB.setOnAction(event -> this.handleCheckboxEvent((ActionEvent)event));
        this.foCB.setId("FADGI_O");
        Label foLabel = new Label("Files with FADGI-O Violations");
        foLabel.setLabelFor((Node)this.foCB);
        FontIcon icon3 = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
        icon3.getStyleClass().add((Object)"fadgi-o-warning");
        icon3.setIconSize(18);
        foLabel.setGraphic((Node)icon3);
        HBox foHBox = new HBox();
        foHBox.setSpacing(10.0);
        foHBox.getChildren().add((Object)this.foCB);
        foHBox.getChildren().add((Object)foLabel);
        grid.add((Node)foHBox, 0, 4);
        int foErrors = DatabaseSummary.getErrorCount(ValidationRuleSetEnum.FADGI_O);
        grid.add((Node)new Label(String.valueOf(foErrors)), 1, 4);
        foLabel.setAccessibleText(foErrors + " files with FADGI-O violations.");
        this.foCB.setOnAction(event -> this.handleCheckboxEvent((ActionEvent)event));
        Label warningMessage = new Label("If 'Errors Only' checkbox is selected, deselect and reselect to see updated warnings.");
        warningMessage.setFocusTraversable(true);
        grid.add((Node)warningMessage, 0, 6);
    }

    private void handleCheckboxEvent(ActionEvent event) {
        if (event.getSource() instanceof CheckBox) {
            CheckBox cb = (CheckBox)event.getSource();
            String id = cb.getId();
            this.handleCheckboxEventId(id);
        }
    }

    private void handleCheckboxEventId(String id) {
        if ("SMPTE_C".equals(id)) {
            ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.SMPTE_C);
        } else if ("FADGI_SR".equals(id)) {
            ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_SR);
        } else if ("FADGI_R".equals(id)) {
            ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_R);
        } else if ("FADGI_O".equals(id)) {
            ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_O);
        }
    }
}

