/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.parser.MetadataColumn;
import com.portalmedia.embarc.parser.dpx.DPXFileInformation;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import com.portalmedia.embarc.validation.CustomValidationRuleResult;
import com.portalmedia.embarc.validation.ICustomValidationRule;
import java.util.ArrayList;
import java.util.List;

public class CustomValidationRuleSet {
    private List<ICustomValidationRule> rules = new ArrayList<ICustomValidationRule>();

    public void AddRule(ICustomValidationRule rule) {
        this.rules.add(rule);
    }

    public List<CustomValidationRuleResult> Validate(DPXFileInformation fileInfo) {
        ArrayList<CustomValidationRuleResult> results = new ArrayList<CustomValidationRuleResult>();
        DPXMetadata fileData = fileInfo.getFileData();
        for (ICustomValidationRule rule : this.rules) {
            CustomValidationRuleResult result = new CustomValidationRuleResult();
            MetadataColumn column = fileData.getColumn(rule.getColumn());
            result.setPass(rule.isValid(column.getCurrentValue()));
            result.setActualValue(column.getCurrentValue());
            result.setColumn(rule.getColumn());
            result.setExpectedValue(rule.getExpectedValue());
            result.setOperator(rule.getOperator());
            results.add(result);
        }
        return results;
    }
}

