/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import com.portalmedia.embarc.parser.mxf.ManifestParser;
import com.portalmedia.embarc.parser.mxf.ManifestType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.tools.ant.Project;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ManifestParserImpl
implements ManifestParser {
    private File schemaFile;
    private String manifestFileResource = "resources/RDD48-Manifest-20180827.xsd";

    public ManifestParserImpl() throws FileNotFoundException {
        try (InputStream in = Project.class.getClassLoader().getResourceAsStream(this.manifestFileResource);){
            if (in == null) {
                throw new FileNotFoundException("Unable to find manifest schema file");
            }
            File tempFile = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.close();
            }
            in.close();
            this.schemaFile = tempFile;
        }
        catch (Exception e) {
            throw new FileNotFoundException("Unable to find manifest schema file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManifestType isManifest(ByteBuffer bb) {
        ManifestType type;
        File xmlFile;
        block18: {
            xmlFile = null;
            AbstractInterruptibleChannel channel = null;
            type = ManifestType.INVALID_MANIFEST;
            try {
                xmlFile = File.createTempFile("mxf_manifest", null);
                try (FileOutputStream fos = new FileOutputStream(xmlFile, false);){
                    channel = fos.getChannel();
                    ((FileChannel)channel).write(bb);
                    fos.close();
                    if (channel.isOpen()) {
                        channel.close();
                    }
                }
                catch (FileNotFoundException fnf) {
                    System.out.println("Manifest not found");
                }
            }
            catch (IOException e) {
                if (channel == null || !channel.isOpen()) break block18;
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            type = !this.isManifestRoot(xmlFile) ? ManifestType.NOT_MANIFEST : (this.isValidManifest(xmlFile) ? ManifestType.VALID_MANIFEST : ManifestType.INVALID_MANIFEST);
        }
        catch (Exception exception) {
        }
        finally {
            if (xmlFile != null && xmlFile.exists()) {
                xmlFile.delete();
            }
        }
        return type;
    }

    private boolean isManifestRoot(File file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            return root.getNodeName().equals("Manifest");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isValidManifest(File xmlFileSource) {
        StreamSource xmlFile = new StreamSource(xmlFileSource);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(this.schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(xmlFile);
            return true;
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid reason:" + String.valueOf(e));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

