/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.ProgressDialog;
import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXService;
import com.portalmedia.embarc.report.DPXReportService;
import com.portalmedia.embarc.report.HashReportValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.text.Text;

public class WriteFilesDialog
extends Dialog {
    private boolean writeEditedOnly = false;
    private int success = 0;
    private int failures = 0;
    private final List<HashReportValue> report = new LinkedList<HashReportValue>();
    private boolean writeImageReport = false;

    public WriteFilesDialog(String filePath, String csvPath, boolean writeEditedOnly) {
        this.writeEditedOnly = writeEditedOnly;
        this.writeFiles(filePath, csvPath);
    }

    private void writeFiles(final String filePath, final String csvPath) {
        final List<DPXFileInformationViewModel> fileList = DPXFileListHelper.getAllFilesToWrite(this.writeEditedOnly);
        Task<Void> task = new Task<Void>(){

            public Void call() {
                System.currentTimeMillis();
                if (fileList.size() == 0) {
                    this.updateProgress(100L, 100L);
                    this.cancel();
                }
                int count = 0;
                int fileCount = fileList.size();
                double processed = 0.0;
                WriteFilesDialog.this.writeImageReport = csvPath != null && !csvPath.isEmpty() && fileCount > 0;
                WriteFilesDialog.this.report.clear();
                for (DPXFileInformationViewModel file : fileList) {
                    try {
                        String inputPath = file.getProp("path");
                        Object outputPath = inputPath;
                        if (!filePath.isEmpty()) {
                            outputPath = filePath + File.separator + file.getProp("name");
                        }
                        if (WriteFilesDialog.this.writeImageReport) {
                            String imageDataStartString = file.getProp(DPXColumn.OFFSET_TO_IMAGE_DATA);
                            int imageDataStart = Integer.parseInt(imageDataStartString);
                            byte[] originalImageData = DPXFileListHelper.getBytesFromFile(inputPath, imageDataStart);
                            String originalHash = DPXFileListHelper.getCrc32Hash(originalImageData);
                            if (DPXService.writeFile(file, inputPath, (String)outputPath)) {
                                ++WriteFilesDialog.this.success;
                                DPXFileListHelper.setFileShouldBeWritten(file, false, true);
                            } else {
                                ++WriteFilesDialog.this.failures;
                            }
                            int newImageOffset = file.getOffsetToImageData();
                            byte[] newImageData = DPXFileListHelper.getBytesFromFile((String)outputPath, newImageOffset);
                            String newHash = DPXFileListHelper.getCrc32Hash(newImageData);
                            WriteFilesDialog.this.report.add(new HashReportValue((String)outputPath, originalHash, newHash));
                        } else if (DPXService.writeFile(file, inputPath, (String)outputPath)) {
                            ++WriteFilesDialog.this.success;
                            DPXFileListHelper.setFileShouldBeWritten(file, false, true);
                        } else {
                            ++WriteFilesDialog.this.failures;
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Error writing file");
                    }
                    processed = ++count * 100 / fileCount;
                    this.updateProgress(processed, 100.0);
                }
                try {
                    if (WriteFilesDialog.this.writeImageReport && count > 0) {
                        DPXReportService.WriteImageHashCsv(WriteFilesDialog.this.report, csvPath);
                    }
                }
                catch (IOException e) {
                    System.out.println("Error writing hash report");
                }
                return null;
            }
        };
        ProgressDialog progressDialog = new ProgressDialog();
        progressDialog.activateProgressBar(task);
        progressDialog.getDialogAlert().show();
        Text filesToProcess = new Text("Files to Write: " + Integer.toString(fileList.size()));
        progressDialog.setCountLabel((Node)filesToProcess);
        progressDialog.getDialogAlert().setOnCloseRequest(arg_0 -> WriteFilesDialog.lambda$writeFiles$0((Task)task, arg_0));
        new Thread((Runnable)task).start();
        task.setOnSucceeded(e -> {
            Text filesWritten = new Text("File Writing Complete!");
            progressDialog.setCountLabel((Node)filesWritten);
            int matches = 0;
            for (HashReportValue hrv : this.report) {
                String newHash;
                String orgHash = hrv.getOriginalHash();
                if (!orgHash.equals(newHash = hrv.getNewHash())) continue;
                ++matches;
            }
            ArrayList<Text> labels = new ArrayList<Text>();
            labels.add(new Text("Total Files Written: " + this.success));
            labels.add(new Text("Total Failures: " + this.failures));
            if (this.writeImageReport) {
                labels.add(new Text("Matching Image Checksums: " + matches));
            }
            progressDialog.showLabels(labels);
            progressDialog.showCloseButton();
        });
        task.setOnCancelled(e -> {
            Text filesWritten = new Text("WRITE FILES CANCELLED");
            progressDialog.setCountLabel((Node)filesWritten);
            ArrayList<Text> labels = new ArrayList<Text>();
            labels.add(new Text("No edited files were found."));
            progressDialog.showLabels(labels);
            progressDialog.cancelProgressBar();
            progressDialog.showCloseButton();
        });
    }

    private static /* synthetic */ void lambda$writeFiles$0(Task task, DialogEvent e) {
        if (task.isRunning()) {
            System.out.println("WRITE FILES CANCELLED BY USER");
            task.cancel();
        }
    }
}

