/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.helper.CleanInputPathHelper;
import com.portalmedia.embarc.gui.mxf.WriteFilesDialogMXF;
import com.portalmedia.embarc.system.UserPreferencesService;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;

public class WriteFilesModalControllerMXF {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());

    public static WriteFilesModalControllerMXF getInstance() {
        return ControllerHolder.INSTANCE;
    }

    private WriteFilesModalControllerMXF() {
    }

    public void showWriteFilesDialog() {
        String outputDir;
        UserPreferencesService userPreferences = new UserPreferencesService();
        ChoiceDialog dialog = new ChoiceDialog();
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.DOWNLOAD);
        icon.getStyleClass().add((Object)"write-files-icon");
        icon.setIconSize(20);
        dialog.setGraphic((Node)icon);
        dialog.getDialogPane().setPrefSize(525.0, 320.0);
        dialog.setTitle("Write Files");
        dialog.setHeaderText("Write Files to Disk");
        dialog.initOwner((Window)Main.getPrimaryStage());
        ButtonType loginButtonType = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType writeFilesButtonType = new ButtonType("Write Files", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{loginButtonType, writeFilesButtonType});
        dialog.setResultConverter(type -> {
            ButtonBar.ButtonData data = type == null ? null : type.getButtonData();
            return data;
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        CheckBox writeEditedCb = new CheckBox("Write only edited files");
        writeEditedCb.setSelected(userPreferences.getWriteOnlyEditedFiles());
        CheckBox saveAsCb = new CheckBox("Save files to a separate directory");
        saveAsCb.setSelected(userPreferences.getSaveToSeparateDirectory());
        String reportDir = userPreferences.getImageChecksumValidationReportPath();
        String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
        if (reportDir == null || reportDir.isEmpty()) {
            reportDir = cleanHomePath;
        }
        if ((outputDir = userPreferences.getSaveToPath()) == null || outputDir.isEmpty()) {
            outputDir = cleanHomePath;
        }
        final Label writeFilesPath = new Label(outputDir);
        final Button chooseOutputDirButton = new Button();
        chooseOutputDirButton.setText("Save Files To...");
        chooseOutputDirButton.setPrefWidth(125.0);
        chooseOutputDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DirectoryChooser dirChooser = new DirectoryChooser();
                String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
                dirChooser.setInitialDirectory(new File(cleanHomePath));
                dirChooser.setTitle("Select a directory");
                File dir = dirChooser.showDialog(null);
                if (dir != null) {
                    writeFilesPath.setText(dir.getAbsolutePath());
                }
            }
        });
        chooseOutputDirButton.setDisable(!saveAsCb.isSelected());
        writeFilesPath.setDisable(true);
        saveAsCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                chooseOutputDirButton.setDisable(newValue == false);
                writeFilesPath.setDisable(newValue == false);
            }
        });
        grid.add((Node)writeEditedCb, 0, 0, 2, 1);
        grid.add((Node)saveAsCb, 0, 1, 2, 1);
        grid.add((Node)chooseOutputDirButton, 0, 2);
        grid.add((Node)writeFilesPath, 1, 2);
        dialog.getDialogPane().setContent((Node)grid);
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonBar.ButtonData.OK_DONE) {
            userPreferences.setWriteOnlyEditedFiles(writeEditedCb.isSelected());
            userPreferences.setSaveToSeparateDirectory(saveAsCb.isSelected());
            if (saveAsCb.isSelected()) {
                String newOutputDir = writeFilesPath.getText();
                userPreferences.setSaveToPath(newOutputDir);
            }
            String tmpWriteFilesPath = saveAsCb.isSelected() ? writeFilesPath.getText() : "";
            try {
                WriteFilesDialogMXF d = new WriteFilesDialogMXF(tmpWriteFilesPath, writeEditedCb.isSelected());
                d.initOwner((Window)Main.getPrimaryStage());
            }
            catch (FileNotFoundException e1) {
                LOGGER.log(Level.SEVERE, e1.toString(), e1);
            }
        }
    }

    private static class ControllerHolder {
        private static final WriteFilesModalControllerMXF INSTANCE = new WriteFilesModalControllerMXF();

        private ControllerHolder() {
        }
    }
}

