/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import java.util.ArrayList;
import java.util.List;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.model.impl.AS07CoreDMSDeviceObjectsImpl;

public class DeviceSetHelper {
    private String comma = ",,,,";
    private String slash = "////";

    public ArrayList<AS07CoreDMSDeviceObjectsImpl> createDeviceListFromString(String values) {
        String[] valList;
        ArrayList<AS07CoreDMSDeviceObjectsImpl> devices = new ArrayList<AS07CoreDMSDeviceObjectsImpl>();
        for (String v : valList = values.split(this.slash)) {
            if (v == "") continue;
            devices.add(this.createDeviceFromString(v));
        }
        return devices;
    }

    public AS07CoreDMSDeviceObjectsImpl createDeviceFromString(String values) {
        String[] valList = values.split(this.comma);
        AS07CoreDMSDeviceObjectsImpl device = new AS07CoreDMSDeviceObjectsImpl();
        if (valList.length > 0) {
            device.setDeviceType(valList[0]);
        }
        if (valList.length > 1) {
            device.setManufacturer(valList[1]);
        }
        if (valList.length > 2) {
            device.setModel(valList[2]);
        }
        if (valList.length > 3) {
            device.setSerialNumber(valList[3]);
        }
        if (valList.length > 4) {
            device.setUsageDescription(valList[4]);
        }
        return device;
    }

    public String devicesToString(List<AS07CoreDMSDeviceObjectsImpl> devices) {
        Object toReturn = "";
        for (int i = 0; i < devices.size(); ++i) {
            AS07CoreDMSDeviceObjectsImpl device = devices.get(i);
            toReturn = (String)toReturn + this.deviceToString(device);
            if (i >= devices.size() - 1) continue;
            toReturn = (String)toReturn + this.slash;
        }
        return toReturn;
    }

    public String deviceToString(AS07CoreDMSDeviceObjectsImpl device) {
        String type = "";
        try {
            type = device.getDeviceType();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        String manu = "";
        try {
            manu = device.getManufacturer();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        String model = "";
        try {
            model = device.getModel();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        String serial = "";
        try {
            serial = device.getSerialNumber();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        String usage = "";
        try {
            usage = device.getUsageDescription();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        return type + this.comma + manu + this.comma + model + this.comma + serial + this.comma + usage;
    }
}

