/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.DPXColumnValidationRules;
import com.portalmedia.embarc.validation.DPXFileValidationRules;
import com.portalmedia.embarc.validation.IFileValidationRule;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.objects.Id;

public class DPXFileInformationViewModel
implements Mappable {
    @Id
    private int id;
    private boolean edited = false;
    private LinkedHashMap<String, String> properties;
    private HashMap<ColumnDef, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> invalidRules;
    private HashSet<ValidationRuleSetEnum> invalidRuleSetList;
    HashSet<IFileValidationRule> invalidFileRules;
    private HashMap<ValidationRuleSetEnum, List<ColumnDef>> ruleSetsBroken;
    private boolean userDefinedDataEdited = false;
    private boolean userDefinedDataSet = false;
    private boolean smptecError;
    private boolean fadgioError;
    private boolean fadgirError;
    private boolean fadgisrError;
    private int userDefinedDataOriginalLength = 0;
    private boolean fileShouldBeWritten = true;

    public DPXFileInformationViewModel() {
        this(null, null, null);
        this.properties = new LinkedHashMap();
        this.invalidRules = new HashMap();
        this.invalidFileRules = new HashSet();
        this.invalidRuleSetList = new HashSet();
        this.ruleSetsBroken = new HashMap();
    }

    public DPXFileInformationViewModel(String name, String path, String uuid) {
    }

    public void autoPopulateName() {
        String name = this.getProp("name");
        if (name.length() <= DPXColumn.IMAGE_FILE_NAME.getLength()) {
            this.setProp(DPXColumn.IMAGE_FILE_NAME, name);
            this.setEdited(true);
        }
    }

    public HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> getFileValidations(ColumnDef column) {
        HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> toReturn = new HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>>();
        for (IFileValidationRule v : DPXFileValidationRules.getInstance().getColumnRules(column)) {
            if (v.isValid(this)) continue;
            HashMap<Object, Object> columnViolations = new HashMap();
            if (toReturn.containsKey(v.getTargetColumn())) {
                columnViolations = toReturn.get(v.getTargetColumn());
            }
            List<IValidationRule> ruleSetViolations = new LinkedList<IValidationRule>();
            if (columnViolations.containsKey((Object)v.getRuleSet())) {
                ruleSetViolations = (List)columnViolations.get((Object)v.getRuleSet());
            }
            ruleSetViolations.add(v.getValidationRule());
            columnViolations.put((Object)v.getRuleSet(), ruleSetViolations);
            toReturn.put(v.getTargetColumn(), columnViolations);
        }
        return toReturn;
    }

    public int getId() {
        return this.id;
    }

    public HashSet<IFileValidationRule> getInvalidFileRules() {
        return this.invalidFileRules;
    }

    public HashMap<ColumnDef, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> getInvalidRules() {
        return this.invalidRules;
    }

    public HashSet<ValidationRuleSetEnum> getInvalidRuleSetList() {
        this.invalidRuleSetList.clear();
        for (ColumnDef c : this.invalidRules.keySet()) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> r = this.invalidRules.get(c);
            for (ValidationRuleSetEnum rs : r.keySet()) {
                if (this.invalidRules.get(c).get((Object)rs).isEmpty()) continue;
                this.invalidRuleSetList.add(rs);
            }
        }
        return this.invalidRuleSetList;
    }

    public HashMap<ColumnDef, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> getInvalidRuleSets() {
        return this.invalidRules;
    }

    public HashMap<ValidationRuleSetEnum, List<IValidationRule>> getInvalidRuleSets(ColumnDef column) {
        return this.invalidRules.get(column);
    }

    public int getOffsetToImageData() {
        int totalMetadata = 0;
        for (DPXColumn column : DPXColumn.values()) {
            if (column == DPXColumn.USER_DEFINED_DATA || column == DPXColumn.USER_IDENTIFICATION) continue;
            totalMetadata += column.getLength();
        }
        String userDefinedDataLengthStr = this.getProp(DPXColumn.USER_DEFINED_HEADER_LENGTH);
        if (userDefinedDataLengthStr.isEmpty()) {
            return totalMetadata;
        }
        return totalMetadata + Integer.parseInt(userDefinedDataLengthStr);
    }

    public String getProp(ColumnDef column) {
        String c;
        String columnName = column.getDisplayName() + column.getSectionDisplayName();
        if (column.hasSubsection()) {
            columnName = columnName + column.getSubsection().getDisplayName();
        }
        if ((c = this.properties.get(columnName)) == null) {
            return "";
        }
        return c;
    }

    public String getProp(String columnName) {
        return this.properties.get(columnName);
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public HashMap<ValidationRuleSetEnum, List<ColumnDef>> getRuleSetsBroken() {
        return this.ruleSetsBroken;
    }

    public HashMap<ValidationRuleSetEnum, List<IValidationRule>> getRuleViolations(ColumnDef column) {
        return this.invalidRules.get(column);
    }

    public int getUserDefinedDataOriginalLength() {
        return this.userDefinedDataOriginalLength;
    }

    public boolean getFileShouldBeWritten() {
        return this.fileShouldBeWritten;
    }

    public boolean hasError(Set<ValidationRuleSetEnum> ruleSets) {
        for (ColumnDef c : this.invalidRules.keySet()) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleSetViolations = this.invalidRules.get(c);
            for (ValidationRuleSetEnum rule : ruleSets) {
                List<IValidationRule> rules;
                if (ruleSetViolations == null || !ruleSetViolations.containsKey((Object)rule) || (rules = ruleSetViolations.get((Object)rule)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public boolean isFadgioError() {
        return this.fadgioError;
    }

    public boolean isFadgirError() {
        return this.fadgirError;
    }

    public boolean isFadgisrError() {
        return this.fadgisrError;
    }

    public boolean isSmptecError() {
        return this.smptecError;
    }

    public boolean isUserDefinedDataEdited() {
        return this.userDefinedDataEdited;
    }

    public boolean isUserDefinedDataSet() {
        return this.userDefinedDataSet;
    }

    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setId((Integer)document.get("id"));
            this.setProperties((LinkedHashMap)document.get("properties"));
            this.setInvalidRules((HashMap)document.get("invalidRules"));
            this.setInvalidRuleSetList((HashSet)document.get("invalidRuleSetList"));
            this.setInvalidFileRules((HashSet)document.get("invalidFileRules"));
            this.setUserDefinedDataEdited((Boolean)document.get("userDefinedDataEdited"));
            this.setUserDefinedDataSet((Boolean)document.get("userDefinedDataSet"));
            this.setUserDefinedDataOriginalLength((Integer)document.get("userDefinedDataOriginalLength"));
            this.setEdited((Boolean)document.get("edited"));
            this.setSmptecError((Boolean)document.get("smptecError"));
            this.setFadgioError((Boolean)document.get("fadgioError"));
            this.setFadgirError((Boolean)document.get("fadgirError"));
            this.setFadgisrError((Boolean)document.get("fadgisrError"));
            this.setRuleSetsBroken((HashMap)document.get("ruleSetsBroken"));
            this.setFileShouldBeWritten((Boolean)document.get("fileShouldBeWritten"));
        }
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public void setFadgioError(boolean fadgioError) {
        this.fadgioError = fadgioError;
    }

    public void setFadgirError(boolean fadgirError) {
        this.fadgirError = fadgirError;
    }

    public void setFadgisrError(boolean fadgisrError) {
        this.fadgisrError = fadgisrError;
    }

    public void setId(int id) {
        this.id = id;
        this.setProp("id", String.valueOf(id));
    }

    public void setInvalidFileRules(HashSet<IFileValidationRule> invalidFileRules) {
        this.invalidFileRules = invalidFileRules;
    }

    public void setInvalidRules(HashMap<ColumnDef, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> invalidRules) {
        this.invalidRules = invalidRules;
    }

    public void setInvalidRuleSetList(HashSet<ValidationRuleSetEnum> invalidRuleSetList) {
        this.invalidRuleSetList = invalidRuleSetList;
    }

    public void setProp(ColumnDef key, String value) {
        String columnName = key.getDisplayName() + key.getSectionDisplayName();
        if (key.hasSubsection()) {
            columnName = columnName + key.getSubsection().getDisplayName();
        }
        if (value == null) {
            return;
        }
        this.properties.put(columnName, value);
        if (key == DPXColumn.USER_DEFINED_DATA) {
            int userIdLength = this.getProp(DPXColumn.USER_IDENTIFICATION).length();
            if (value.length() == 0 && userIdLength == 0 && this.getProp(DPXColumn.USER_DEFINED_HEADER_LENGTH).isEmpty()) {
                this.updateUserDefinedDataOriginalNull();
            } else if (value.length() == 0 && userIdLength == 0) {
                this.updateUserDefinedDataOriginalLength(0);
            } else {
                totalLength = value.length() + DPXColumn.USER_IDENTIFICATION.getLength();
                this.updateUserDefinedDataOriginalLength(totalLength);
            }
        } else if (key == DPXColumn.USER_IDENTIFICATION) {
            int userDefinedDataLength = this.getProp(DPXColumn.USER_DEFINED_DATA).length();
            if (value.length() == 0 && userDefinedDataLength == 0 && this.getProp(DPXColumn.USER_DEFINED_HEADER_LENGTH).isEmpty()) {
                this.updateUserDefinedDataOriginalNull();
            } else if (value.length() == 0 && userDefinedDataLength == 0) {
                this.updateUserDefinedDataOriginalLength(0);
            } else {
                totalLength = DPXColumn.USER_IDENTIFICATION.getLength() + userDefinedDataLength;
                this.updateUserDefinedDataOriginalLength(totalLength);
            }
        }
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleSets = DPXColumnValidationRules.getInstance().getRuleSet(key);
        HashMap invalidRuleSets = new HashMap();
        HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> invalidFileValidations = this.getFileValidations(key);
        for (ValidationRuleSetEnum ruleSet : ruleSets.keySet()) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> fileValidations;
            List<ColumnDef> brokenForThisRule = this.ruleSetsBroken.get((Object)ruleSet);
            if (brokenForThisRule == null) {
                brokenForThisRule = new LinkedList<ColumnDef>();
            }
            brokenForThisRule.remove(key);
            List<IValidationRule> rules = ruleSets.get((Object)ruleSet);
            LinkedList<IValidationRule> invalidRules = new LinkedList<IValidationRule>();
            if (rules != null) {
                for (IValidationRule rule : rules) {
                    if (rule.isValid(value)) continue;
                    invalidRules.add(rule);
                    brokenForThisRule.add(key);
                }
            }
            if ((fileValidations = invalidFileValidations.get(key)) != null) {
                List<IValidationRule> fileRules = fileValidations.get((Object)ruleSet);
                for (IValidationRule fvr : fileRules) {
                    if (fvr.isValid(value)) continue;
                    invalidRules.add(fvr);
                    brokenForThisRule.add(key);
                }
            }
            if (!invalidRules.isEmpty()) {
                invalidRuleSets.put(ruleSet, invalidRules);
            }
            this.ruleSetsBroken.put(ruleSet, brokenForThisRule);
        }
        this.invalidRules.remove(key);
        if (!invalidRuleSets.isEmpty()) {
            this.invalidRules.put(key, invalidRuleSets);
        }
        this.setRuleSetErrors();
    }

    public void setProp(String columnName, String value) {
        this.properties.put(columnName, value);
    }

    public void setProperties(LinkedHashMap<String, String> properties) {
        this.properties = properties;
    }

    private void setRuleSetErrors() {
        for (ValidationRuleSetEnum rule : ValidationRuleSetEnum.values()) {
            boolean hasErrors;
            int count = 0;
            List<ColumnDef> columns = this.ruleSetsBroken.get((Object)rule);
            if (columns != null) {
                count = columns.size();
            }
            boolean bl = hasErrors = count > 0;
            if (rule == ValidationRuleSetEnum.SMPTE_C) {
                this.smptecError = hasErrors;
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                this.fadgioError = hasErrors;
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                this.fadgirError = hasErrors;
                continue;
            }
            if (rule != ValidationRuleSetEnum.FADGI_SR) continue;
            this.fadgisrError = hasErrors;
        }
    }

    public void setRuleSetsBroken(HashMap<ValidationRuleSetEnum, List<ColumnDef>> ruleSetsBroken) {
        this.ruleSetsBroken = ruleSetsBroken;
    }

    public void setSmptecError(boolean smptecError) {
        this.smptecError = smptecError;
    }

    public void setUserDefinedDataEdited(boolean userDefinedDataEdited) {
        this.userDefinedDataEdited = userDefinedDataEdited;
    }

    public void setUserDefinedDataOriginalLength(Integer length) {
        this.userDefinedDataOriginalLength = length;
    }

    public void setFileShouldBeWritten(boolean shouldBeWritten) {
        this.fileShouldBeWritten = shouldBeWritten;
    }

    public void setUserDefinedDataSet(boolean userDefinedDataSet) {
        this.userDefinedDataSet = userDefinedDataSet;
    }

    public void updateUserDefinedDataOriginalLength(Integer totalLength) {
        if (!this.userDefinedDataSet) {
            int origLen;
            String origLenStr = this.getProp(DPXColumn.USER_DEFINED_HEADER_LENGTH);
            this.userDefinedDataOriginalLength = origLenStr.isEmpty() ? 0 : (origLen = Integer.parseInt(origLenStr));
            this.userDefinedDataSet = true;
        } else {
            this.userDefinedDataEdited = true;
            String udhlName = DPXColumn.USER_DEFINED_HEADER_LENGTH.getDisplayName() + DPXColumn.USER_DEFINED_HEADER_LENGTH.getSectionDisplayName();
            this.properties.put(udhlName, String.valueOf(totalLength));
        }
    }

    public void updateUserDefinedDataOriginalNull() {
        this.userDefinedDataSet = true;
    }

    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("id", (Object)this.getId());
        document.put("properties", this.getProperties());
        document.put("invalidRules", this.getInvalidRules());
        document.put("invalidRuleSetList", this.getInvalidRuleSetList());
        document.put("invalidFileRules", this.getInvalidFileRules());
        document.put("userDefinedDataEdited", (Object)this.isUserDefinedDataEdited());
        document.put("userDefinedDataSet", (Object)this.isUserDefinedDataSet());
        document.put("userDefinedDataOriginalLength", (Object)this.getUserDefinedDataOriginalLength());
        document.put("edited", (Object)this.isEdited());
        document.put("smptecError", (Object)this.isSmptecError());
        document.put("fadgioError", (Object)this.isFadgioError());
        document.put("fadgirError", (Object)this.isFadgirError());
        document.put("fadgisrError", (Object)this.isFadgisrError());
        document.put("ruleSetsBroken", this.getRuleSetsBroken());
        document.put("fileShouldBeWritten", (Object)this.getFileShouldBeWritten());
        return document;
    }
}

