/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.cli;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.MetadataColumn;
import com.portalmedia.embarc.parser.dpx.DPXFileInformation;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonWriterDpx {
    public static void writeJsonDPXFiles(String outputPath, TreeMap<String, DPXFileInformation> dpxFileList) throws JSONException, IOException {
        JSONObject j = new JSONObject();
        ArrayList<JSONObject> jsonObs = new ArrayList<JSONObject>();
        for (DPXFileInformation dpxFileInfo : dpxFileList.values()) {
            JSONObject fileJson = new JSONObject();
            HashMap<String, String> fileValues = JsonWriterDpx.createJsonFileInfo(dpxFileInfo);
            fileJson.put("General", fileValues);
            DPXMetadata data = dpxFileInfo.getFileData();
            LinkedHashMap<ColumnDef, MetadataColumn> metadata = data.getMetadataHashMap();
            String currentSection = null;
            HashMap<String, String> values = new HashMap<String, String>();
            for (Map.Entry<ColumnDef, MetadataColumn> entry : metadata.entrySet()) {
                ColumnDef key = entry.getKey();
                MetadataColumn value = entry.getValue();
                if (currentSection != key.getSectionDisplayName()) {
                    if (values.size() > 0) {
                        fileJson.put(currentSection, values);
                    }
                    currentSection = key.getSectionDisplayName();
                    values = new HashMap();
                }
                values.put(key.getDisplayName(), value.getStandardizedValue());
            }
            fileJson.put(currentSection, values);
            jsonObs.add(fileJson);
        }
        j.put("Files", jsonObs);
        try (FileWriter writer = new FileWriter(outputPath);){
            j.write((Writer)writer);
            writer.close();
        }
    }

    private static HashMap<String, String> createJsonFileInfo(DPXFileInformation dpxFileInfo) {
        HashMap<String, String> values = new HashMap<String, String>();
        File file = new File(dpxFileInfo.getPath());
        values.put("FileName", dpxFileInfo.getName());
        values.put("FilePath", dpxFileInfo.getPath());
        values.put("FileSize", Long.toString(file.length()));
        return values;
    }
}

