/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.parser.ColumnDef;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.HBox;
import org.apache.commons.lang.StringUtils;
import org.controlsfx.control.textfield.CustomTextField;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ValidationChangeListenerMXF
implements ChangeListener<String> {
    private CustomTextField textField;
    ColumnDef column;
    HBox validationInfo;

    public ValidationChangeListenerMXF(CustomTextField textField, ColumnDef column, HBox validationInfo) {
        this.textField = textField;
        this.column = column;
        this.validationInfo = validationInfo;
    }

    public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
        this.setMissingRequiredField(newValue);
    }

    public void setMissingRequiredField(String value) {
        if (this.column.isRequired() && StringUtils.isBlank((String)value)) {
            FontIcon icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
            icon.getStyleClass().add((Object)"fadgi-sr-warning");
            this.validationInfo.getChildren().add((Object)icon);
            this.textField.setAccessibleText("Missing Required Value");
        } else {
            this.validationInfo = new HBox();
        }
    }
}

