/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.ProgressSpinner;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.dpx.ValidationCellFactory;
import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.helper.RowNumberManager;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.gui.model.DPXMetadataColumnViewModel;
import com.portalmedia.embarc.gui.model.SelectedFilesSummary;
import com.portalmedia.embarc.gui.model.TabSummary;
import com.portalmedia.embarc.gui.model.TableState;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.dpx.DPXBatchProcessor;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXColumnHelpText;
import com.portalmedia.embarc.parser.dpx.DPXImageElement;
import com.portalmedia.embarc.parser.dpx.DPXMetadataColumnViewModelList;
import com.portalmedia.embarc.parser.dpx.DPXSection;
import com.portalmedia.embarc.parser.dpx.DPXSequenceError;
import com.portalmedia.embarc.system.UserPreferencesService;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DialogEvent;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Callback;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;

public class CenterPaneController
implements Initializable {
    @FXML
    private BorderPane borderPane;
    @FXML
    private TableView<DPXFileInformationViewModel> table;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab generalTab;
    @FXML
    private Tab fileInformationTab;
    @FXML
    private Tab imageInformationTab;
    @FXML
    private Tab imageSourceInformationTab;
    @FXML
    private Tab motionPictureFilmTab;
    @FXML
    private Tab televisionTab;
    @FXML
    private Tab userDefinedTab;
    @FXML
    private SectionDef selectedSection;
    private SelectedFilesSummary selectedFilesSummary;
    private TableView.TableViewSelectionModel<DPXFileInformationViewModel> tableSelectionModel;
    private Boolean columnsHaveBeenSet = false;
    private List<String> shownImageElements;
    private List<TableColumn<DPXFileInformationViewModel, ?>> userHiddenColumns = new ArrayList();
    private TabSummary tabSummary;
    private boolean filteredByError = false;
    private boolean userPreferencesSet = false;
    private List<DPXSequenceError> filenameSequenceErrorList = new ArrayList<DPXSequenceError>();
    private List<DPXSequenceError> imageFilenameSequenceErrorList = new ArrayList<DPXSequenceError>();
    private List<DPXSequenceError> sourceImageFilenameSequenceErrorList = new ArrayList<DPXSequenceError>();
    private List<DPXSequenceError> framePositionSequenceErrorList = new ArrayList<DPXSequenceError>();
    private final String TAB_VALIDATION_WARNING = " Contains validation error";

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorDPX.getInstance().registerCenterPaneController(this);
        this.table.setFocusTraversable(true);
        this.table.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    TableColumn focusedColumn = CenterPaneController.this.table.getFocusModel().getFocusedCell().getTableColumn();
                    if (focusedColumn != null && focusedColumn.isSortable()) {
                        if (focusedColumn.getSortType() == TableColumn.SortType.ASCENDING) {
                            focusedColumn.setSortType(TableColumn.SortType.DESCENDING);
                        } else {
                            focusedColumn.setSortType(TableColumn.SortType.ASCENDING);
                        }
                        CenterPaneController.this.table.getSortOrder().clear();
                        CenterPaneController.this.table.getSortOrder().add((Object)focusedColumn);
                    }
                    event.consume();
                }
            }
        });
        this.tableSelectionModel = this.table.getSelectionModel();
        this.tableSelectionModel.getSelectedItems().addListener(change -> {
            boolean selectAll;
            ObservableList files = this.table.getSelectionModel().getSelectedItems();
            boolean selectAllChanged = false;
            boolean bl = selectAll = files.size() == this.table.getItems().size();
            if (TableState.isSelectAll() != selectAll) {
                selectAllChanged = true;
            }
            TableState.setSelectAll(selectAll);
            DPXFileListHelper.setSelectAll(selectAll);
            ControllerMediatorDPX.getInstance().setSelectedFileList((ObservableList<DPXFileInformationViewModel>)files);
            if (!TableState.isSelectAll() && !TableState.getDeleteFiles() || selectAllChanged) {
                TableState.setUpdateSummary(true);
                TableState.setUpdateEditor(true);
                this.updateData();
                this.updateTable();
            }
        });
        this.tableSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.tabSummary = new TabSummary();
        this.shownImageElements = new LinkedList<String>();
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_1.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_2.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_3.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_4.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_5.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_6.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_7.getDisplayName());
        this.shownImageElements.add(DPXImageElement.IMAGE_ELEMENT_8.getDisplayName());
        this.setTabClickListener();
        this.setIsEditingListener();
        this.refreshEditor(false);
    }

    private void initUserPreferences() {
        if (!this.userPreferencesSet) {
            UserPreferencesService userPreferences = new UserPreferencesService();
            List<String> hiddenColNames = userPreferences.getHiddenDPXColumns();
            for (TableColumn column : this.table.getColumns()) {
                if (!hiddenColNames.contains(column.getId()) || this.userHiddenColumns.contains(column)) continue;
                column.setVisible(false);
                this.userHiddenColumns.add(column);
            }
            this.userPreferencesSet = true;
        }
    }

    public void refreshEditor(boolean updateSummary) {
        int selectedRowCount;
        if (updateSummary) {
            this.selectedFilesSummary = DPXFileListHelper.createSelectedFilesSummary((List<DPXFileInformationViewModel>)this.table.getSelectionModel().getSelectedItems());
            this.setSelectedRuleSets(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
            this.setTabWarnings();
            this.setColumnSequenceGapWarnings();
        }
        if ((selectedRowCount = this.table.getSelectionModel().getSelectedItems().size()) > 0 && this.selectedSection != null) {
            ControllerMediatorDPX.getInstance().setEditor(this.selectedSection);
        } else if (selectedRowCount > 0) {
            ControllerMediatorDPX.getInstance().resetEditor(this.selectedSection);
            ControllerMediatorDPX.getInstance().setGeneralEditor();
        } else {
            ControllerMediatorDPX.getInstance().resetEditor(this.selectedSection);
        }
    }

    public void refreshValidation() {
        this.table.refresh();
    }

    public void selectAllFiles() {
        ProgressSpinner spinner = new ProgressSpinner();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                TableState.setSelectAll(true);
                TableState.setUpdateSummary(true);
                TableState.setUpdateEditor(true);
                DPXFileListHelper.setSelectAll(true);
                CenterPaneController.this.updateData();
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            Platform.runLater(() -> this.updateTable());
            spinner.getDialogStage().hide();
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    private void selectSection(SectionDef section) {
        this.selectedSection = section;
        this.refreshEditor(false);
    }

    private void setColumnContextMenu(TableColumn<DPXFileInformationViewModel, String> col) {
        ContextMenu cm = new ContextMenu();
        cm.setStyle("-fx-font-size: 12px");
        MenuItem mi1 = new MenuItem("Auto Populate Name");
        mi1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                CenterPaneController.this.autoPopulateNames();
            }
        });
        cm.getItems().add((Object)mi1);
        col.setContextMenu(cm);
    }

    private void setColumns() {
        if (this.table.getItems().size() != 0) {
            this.setGeneralColumns();
            DPXMetadataColumnViewModelList columnList = DPXMetadataColumnViewModelList.getInstance();
            for (DPXMetadataColumnViewModel mcvm : columnList.getColumns()) {
                String colName;
                String tempColName;
                String helpText = DPXColumnHelpText.getInstance().getHelpText(mcvm.getColumn());
                if (!mcvm.getHasSubsection().booleanValue()) {
                    TableColumn col = new TableColumn(mcvm.getDisplayName());
                    colName = tempColName = mcvm.getDisplayName() + mcvm.getSectionDisplayName();
                    col.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((DPXFileInformationViewModel)cellData.getValue()).getProp(colName)));
                    col.setUserData((Object)mcvm);
                    col.setVisible(false);
                    col.setCellFactory(column -> new ValidationCellFactory((TableColumn<DPXFileInformationViewModel, String>)column));
                    if (mcvm.getColumn() == DPXColumn.IMAGE_FILE_NAME) {
                        this.setColumnContextMenu((TableColumn<DPXFileInformationViewModel, String>)col);
                    }
                    this.setColumnWidth((TableColumn<DPXFileInformationViewModel, String>)col);
                    this.setColumnHeader(col, helpText, mcvm.getColumn().getDisplayName());
                    col.setSortable(true);
                    col.setId(mcvm.getDisplayName());
                    this.setColumnStyles((TableColumn<DPXFileInformationViewModel, String>)col, mcvm);
                    this.table.getColumns().add((Object)col);
                    continue;
                }
                TableColumn subCol = new TableColumn(mcvm.getDisplayName());
                tempColName = mcvm.getDisplayName() + mcvm.getSectionDisplayName();
                colName = tempColName = tempColName + mcvm.getSubsectionName();
                subCol.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((DPXFileInformationViewModel)cellData.getValue()).getProp(colName)));
                subCol.setUserData((Object)mcvm);
                subCol.setVisible(false);
                subCol.setCellFactory(column -> new ValidationCellFactory((TableColumn<DPXFileInformationViewModel, String>)column));
                this.setColumnWidth((TableColumn<DPXFileInformationViewModel, String>)subCol);
                String sectionName = mcvm.getSubsectionName();
                String imageNumber = sectionName.substring(sectionName.length() - 1);
                String subSecDisplayName = imageNumber.concat(" ").concat(mcvm.getDisplayName());
                this.setColumnHeader(subCol, "", subSecDisplayName);
                subCol.setSortable(true);
                subCol.setId(subSecDisplayName);
                this.setColumnStyles((TableColumn<DPXFileInformationViewModel, String>)subCol, mcvm);
                this.table.getColumns().add((Object)subCol);
            }
            this.columnsHaveBeenSet = true;
            ControllerMediatorDPX.getInstance().notifyColumnsSet();
            this.initUserPreferences();
        }
    }

    private void setColumnStyles(TableColumn<DPXFileInformationViewModel, String> col, DPXMetadataColumnViewModel mcvm) {
        if (mcvm.isEditable()) {
            col.getStyleClass().add((Object)"editable-column");
        } else {
            col.getStyleClass().add((Object)"uneditable-column");
        }
    }

    private void setColumnHeader(TableColumn<DPXFileInformationViewModel, ?> col, String helpText, String columnDisplayName) {
        this.setColumnHeader(col, helpText, columnDisplayName, false);
    }

    private void setColumnHeader(TableColumn<DPXFileInformationViewModel, ?> col, String helpText, String columnDisplayName, boolean parentOfSubheaders) {
        HBox hbox = new HBox();
        String defaultStyle = "-fx-font-size: 12px";
        Label title = new Label(columnDisplayName);
        title.setStyle("-fx-font-size: 12px");
        Tooltip tt = new Tooltip(columnDisplayName + "\n\n" + helpText);
        tt.setStyle("-fx-font-size: 12px");
        tt.setPrefWidth(500.0);
        tt.setWrapText(true);
        tt.setAutoHide(false);
        title.setTooltip(tt);
        this.setColumnHeaderSequenceErrorIndicator(columnDisplayName, title, hbox);
        if (parentOfSubheaders) {
            new FontIcon((Ikon)FontAwesomeSolid.CARET_DOWN);
            title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
            FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.CARET_DOWN);
            hbox.getChildren().add((Object)icon);
        }
        hbox.getChildren().add((Object)title);
        hbox.setAlignment(Pos.CENTER);
        hbox.setStyle("-fx-font-size: 12px");
        col.setText(columnDisplayName);
        col.setGraphic((Node)hbox);
        col.setStyle("-fx-padding: 0 0 0 5;");
    }

    private void setColumnHeaderSequenceErrorIndicator(String columnDisplayName, Label title, HBox hbox) {
        if (columnDisplayName == "Filename" && !this.filenameSequenceErrorList.isEmpty()) {
            this.setSequenceErrorIcon(title, hbox);
        }
        if (columnDisplayName == DPXColumn.IMAGE_FILE_NAME.getDisplayName() && !this.imageFilenameSequenceErrorList.isEmpty()) {
            this.setSequenceErrorIcon(title, hbox);
        }
        if (columnDisplayName == DPXColumn.SOURCE_IMAGE_FILENAME.getDisplayName() && !this.sourceImageFilenameSequenceErrorList.isEmpty()) {
            this.setSequenceErrorIcon(title, hbox);
        }
        if (columnDisplayName == DPXColumn.FRAME_POSITION_IN_SEQUENCE.getDisplayName() && !this.framePositionSequenceErrorList.isEmpty()) {
            this.setSequenceErrorIcon(title, hbox);
        }
    }

    private void setSequenceErrorIcon(Label title, HBox hbox) {
        title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION);
        icon.getStyleClass().add((Object)"fadgi-sr-warning");
        hbox.getChildren().add((Object)icon);
    }

    private void setColumnWidth(TableColumn<DPXFileInformationViewModel, String> col) {
        col.setPrefWidth(125.0);
    }

    public void setFiles() {
        ObservableList<DPXFileInformationViewModel> ofl = DPXFileListHelper.getObservableFileList();
        FilteredList filteredList = new FilteredList(ofl);
        filteredList.setPredicate((Predicate)new Predicate<DPXFileInformationViewModel>(){

            @Override
            public boolean test(DPXFileInformationViewModel t) {
                return t.hasError(ControllerMediatorDPX.getInstance().getCurrentRuleSets()) && CenterPaneController.this.filteredByError || !CenterPaneController.this.filteredByError;
            }
        });
        SortedList sortedData = new SortedList((ObservableList)filteredList);
        sortedData.comparatorProperty().bind((ObservableValue)this.table.comparatorProperty());
        this.table.setItems((ObservableList)sortedData);
        this.setSequenceErrorLists();
        if (!this.columnsHaveBeenSet.booleanValue()) {
            this.setColumns();
        }
    }

    private void setGeneralColumns() {
        TableColumn idCol = new TableColumn("Row");
        idCol.setId("Row");
        idCol.setUserData((Object)"General");
        idCol.getStyleClass().add((Object)"general-section");
        idCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<DPXFileInformationViewModel, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<DPXFileInformationViewModel, String> p) {
                int id = ((DPXFileInformationViewModel)p.getValue()).getId();
                int rowNumber = CenterPaneController.this.table.getItems().indexOf(p.getValue()) + 1;
                RowNumberManager.addRow(id, rowNumber);
                return new ReadOnlyObjectWrapper((Object)("" + rowNumber));
            }
        });
        idCol.setSortable(false);
        idCol.setPrefWidth(50.0);
        this.setColumnHeader(idCol, "", "Row");
        TableColumn nameCol = new TableColumn("Filename");
        nameCol.setId("Filename");
        nameCol.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((DPXFileInformationViewModel)cellData.getValue()).getProp("name")));
        nameCol.setUserData((Object)"General");
        nameCol.getStyleClass().add((Object)"general-section");
        this.setColumnWidth((TableColumn<DPXFileInformationViewModel, String>)nameCol);
        this.setColumnHeader(nameCol, "", "Filename");
        TableColumn pathCol = new TableColumn("File Path");
        pathCol.setId("File Path");
        pathCol.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((DPXFileInformationViewModel)cellData.getValue()).getProp("path")));
        pathCol.setUserData((Object)"General");
        pathCol.getStyleClass().add((Object)"general-section");
        this.setColumnWidth((TableColumn<DPXFileInformationViewModel, String>)pathCol);
        this.setColumnHeader(pathCol, "", "File Path");
        this.table.getColumns().add((Object)idCol);
        this.table.getColumns().add((Object)nameCol);
        this.table.getColumns().add((Object)pathCol);
    }

    private void setIsEditingListener() {
        ControllerMediatorDPX.getInstance().isEditingProperty().addListener((ChangeListener)new ChangeListener<Object>(this){

            public void changed(ObservableValue<?> o, Object ov, Object nv) {
                if (((Boolean)nv).booleanValue()) {
                    // empty if block
                }
            }
        });
    }

    public void setSelectedRuleSets(HashSet<ValidationRuleSetEnum> selectedRuleSets) {
        if (this.selectedFilesSummary != null) {
            this.selectedFilesSummary.setValidRuleSets(selectedRuleSets);
        }
        TabSummary.start();
        for (DPXFileInformationViewModel fivm : DPXFileListHelper.getAllFiles(false)) {
            TabSummary.append(fivm, selectedRuleSets);
        }
        this.tabSummary = TabSummary.getTabSummary();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CenterPaneController.this.setTabWarnings();
                CenterPaneController.this.setColumnSequenceGapWarnings();
            }
        });
    }

    private void setTabClickListener() {
        this.tabPane.getSelectionModel().selectedItemProperty().addListener((ov, oldTab, newTab) -> {
            if (this.table.getItems().size() > 0) {
                this.tabPane.requestFocus();
                switch (newTab.getId()) {
                    case "generalTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            if (!col.getUserData().toString().equals("General") && !this.userHiddenColumns.contains(col)) {
                                col.setVisible(false);
                                continue;
                            }
                            col.setVisible(true);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectedSection = null;
                        this.selectSection(this.selectedSection);
                        break;
                    }
                    case "fileInformationTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("File Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.FILE_INFORMATION_HEADER);
                        break;
                    }
                    case "imageInformationTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("Image Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.IMAGE_INFORMATION_HEADER);
                        break;
                    }
                    case "imageSourceInformationTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("Image Source Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.IMAGE_SOURCE_INFORMATION_HEADER);
                        break;
                    }
                    case "motionPictureFilmTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("Motion Picture Film Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.MOTION_PICTURE_FILM_INFORMATION_HEADER);
                        break;
                    }
                    case "televisionTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("Television Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.TELEVISION_INFORMATION_HEADER);
                        break;
                    }
                    case "userDefinedTab": {
                        for (TableColumn col : this.table.getColumns()) {
                            String tmpValue = col.getUserData().toString();
                            if (tmpValue.equals("General")) {
                                if ((col.getId().equals("Filename") || col.getId().equals("Row")) && !this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                            if (mcvm == null) continue;
                            if (mcvm.getSectionDisplayName().equals("User Defined Information") || col.getId().equals("Filename") || col.getId().equals("Row")) {
                                if (!this.userHiddenColumns.contains(col)) {
                                    col.setVisible(true);
                                    continue;
                                }
                                col.setVisible(false);
                                continue;
                            }
                            if (!col.isVisible()) continue;
                            col.setVisible(false);
                        }
                        this.table.scrollToColumnIndex(0);
                        this.selectSection(DPXSection.USER_DEFINED_DATA);
                        break;
                    }
                }
            }
        });
    }

    private void setColumnSequenceGapWarnings() {
        this.setSequenceErrorLists();
        for (TableColumn tableColumn : this.table.getColumns()) {
            String tmpValue = tableColumn.getUserData().toString();
            if (tmpValue.equals("General")) {
                if (tableColumn.getId() != "Filename") continue;
                tableColumn.setGraphic(null);
                this.setColumnHeader(tableColumn, "", "Filename");
                continue;
            }
            DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)tableColumn.getUserData();
            if (mcvm == null || mcvm.getDisplayName() != DPXColumn.IMAGE_FILE_NAME.getDisplayName() && mcvm.getDisplayName() != DPXColumn.SOURCE_IMAGE_FILENAME.getDisplayName() && mcvm.getDisplayName() != DPXColumn.FRAME_POSITION_IN_SEQUENCE.getDisplayName()) continue;
            tableColumn.setGraphic(null);
            this.setColumnHeader(tableColumn, DPXColumnHelpText.getInstance().getHelpText(mcvm.getColumn()), mcvm.getDisplayName());
        }
    }

    public void setTabWarnings() {
        ObservableList tabs = this.tabPane.getTabs();
        for (Tab t : tabs) {
            switch (t.getId()) {
                case "generalTab": {
                    this.removeAccessibleTabWarning(t, "General");
                    break;
                }
                case "fileInformationTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.FILE_INFORMATION_HEADER)) {
                        this.setAccessibleTabWarning(t, "File Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "File Info");
                    break;
                }
                case "imageInformationTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.IMAGE_INFORMATION_HEADER)) {
                        this.setAccessibleTabWarning(t, "Image Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "Image Info");
                    break;
                }
                case "imageSourceInformationTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.IMAGE_SOURCE_INFORMATION_HEADER)) {
                        this.setAccessibleTabWarning(t, "Image Source Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "Image Source Info");
                    break;
                }
                case "motionPictureFilmTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.MOTION_PICTURE_FILM_INFORMATION_HEADER)) {
                        this.setAccessibleTabWarning(t, "Motion Picture Film Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "Motion Picture Film Info");
                    break;
                }
                case "televisionTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.TELEVISION_INFORMATION_HEADER)) {
                        this.setAccessibleTabWarning(t, "Television Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "Television Info");
                    break;
                }
                case "userDefinedTab": {
                    if (this.tabSummary.hasSectionViolation(DPXSection.USER_DEFINED_DATA)) {
                        this.setAccessibleTabWarning(t, "User Defined Info");
                        break;
                    }
                    this.removeAccessibleTabWarning(t, "User Defined Info");
                    break;
                }
            }
        }
    }

    private void setAccessibleTabWarning(Tab t, String titleText) {
        String accessibleText = titleText + " Contains validation error";
        HBox hbox = new HBox();
        String defaultStyle = "-fx-font-size: 12px";
        Label title = new Label(titleText);
        title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION);
        icon.getStyleClass().add((Object)"fadgi-sr-warning");
        hbox.getChildren().add((Object)icon);
        hbox.getChildren().add((Object)title);
        hbox.setAlignment(Pos.CENTER);
        hbox.setStyle("-fx-font-size: 12px");
        t.setGraphic((Node)hbox);
        t.setText(accessibleText);
        t.setStyle("-fx-padding: 0 0 0 5;");
    }

    private void removeAccessibleTabWarning(Tab t, String titleText) {
        HBox hbox = new HBox();
        String defaultStyle = "-fx-font-size: 12px";
        Label title = new Label(titleText);
        title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
        hbox.getChildren().add((Object)title);
        hbox.setAlignment(Pos.CENTER);
        hbox.setStyle("-fx-font-size: 12px");
        t.setGraphic((Node)hbox);
        t.setText(titleText);
        t.setStyle("-fx-padding: 0 0 0 5;");
    }

    public void showColumnVisibilityDialogue() {
        Alert columnVisibilityDialog = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
        columnVisibilityDialog.initModality(Modality.APPLICATION_MODAL);
        columnVisibilityDialog.initOwner((Window)Main.getPrimaryStage());
        columnVisibilityDialog.setResizable(true);
        columnVisibilityDialog.setGraphic(null);
        columnVisibilityDialog.setTitle("Show/hide Columns");
        columnVisibilityDialog.setHeaderText(null);
        columnVisibilityDialog.setContentText("Set individual column visibility");
        List<CheckBox> checkBoxes = this.createColumnVisibilityCheckBoxes();
        if (checkBoxes.size() > 0) {
            GridPane grid = new GridPane();
            grid.setHgap(15.0);
            grid.setVgap(10.0);
            grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            int rowIndex = 1;
            int colIndex = 0;
            String prevSection = "";
            String currentSection = "";
            for (CheckBox cb : checkBoxes) {
                currentSection = cb.getUserData().toString();
                if (prevSection != currentSection) {
                    rowIndex = 1;
                    prevSection = currentSection;
                    Text sectionHead = new Text(currentSection);
                    sectionHead.setStyle("fx-font-weight: bold");
                    grid.add((Node)sectionHead, ++colIndex, 0);
                }
                cb.setStyle("-fx-font-size: 11px");
                grid.add((Node)cb, colIndex, rowIndex);
                ++rowIndex;
            }
            columnVisibilityDialog.getDialogPane().setContent((Node)grid);
        } else {
            columnVisibilityDialog.setContentText("No files in workspace.");
        }
        columnVisibilityDialog.setOnCloseRequest((EventHandler)new EventHandler<DialogEvent>(){

            public void handle(DialogEvent event) {
                int currentTabIdx = CenterPaneController.this.tabPane.getSelectionModel().getSelectedIndex();
                CenterPaneController.this.tabPane.getSelectionModel().selectFirst();
                CenterPaneController.this.tabPane.getSelectionModel().clearAndSelect(currentTabIdx);
            }
        });
        columnVisibilityDialog.showAndWait();
        if (columnVisibilityDialog.getResult() == ButtonType.OK) {
            columnVisibilityDialog.close();
            int currentTabIdx = this.tabPane.getSelectionModel().getSelectedIndex();
            this.tabPane.getSelectionModel().selectFirst();
            this.tabPane.getSelectionModel().clearAndSelect(currentTabIdx);
        }
    }

    private void showEditsAlert(int editedCount) {
        String info = String.format("        %s total fields changed.        ", editedCount);
        if (editedCount == 1) {
            info = String.format("        %s field changed.        ", editedCount);
        }
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Changes Applied", Alert.AlertType.NONE, info, ButtonType.OK);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp(info);
        dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.OK) {
            alert.close();
        }
        ControllerMediatorDPX.getInstance().setEditedFieldsCount(0);
    }

    public void updateChangedValues(final HashMap<DPXColumn, String> changedValues) {
        ProgressSpinner spinner = new ProgressSpinner();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                ObservableList selectedIndices = CenterPaneController.this.table.getSelectionModel().getSelectedIndices();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                ArrayList<Callable<Object>> futures = new ArrayList<Callable<Object>>(selectedIndices.size());
                for (Integer i : selectedIndices) {
                    futures.add(Executors.callable(() -> {
                        try {
                            DPXFileInformationViewModel fivm = (DPXFileInformationViewModel)CenterPaneController.this.table.getItems().get(i.intValue());
                            DPXFileListHelper.updateValues(changedValues, fivm);
                        }
                        catch (Exception e) {
                            System.out.println("Update values error");
                        }
                    }));
                }
                try {
                    executor.invokeAll(futures);
                }
                catch (InterruptedException e) {
                    System.out.println("Update values thread error");
                }
                CenterPaneController.this.selectedFilesSummary = TableState.isSelectAll() ? DPXFileListHelper.createSelectedFilesSummaryAll() : DPXFileListHelper.createSelectedFilesSummary((List<DPXFileInformationViewModel>)CenterPaneController.this.table.getSelectionModel().getSelectedItems());
                CenterPaneController.this.setSelectedRuleSets(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            this.table.refresh();
            this.refreshEditor(false);
            spinner.getDialogStage().hide();
            Platform.runLater(() -> this.showEditsAlert(changedValues.size()));
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    public void updateChangedValuesAllFiles(final HashMap<DPXColumn, String> changedValues) {
        ProgressSpinner spinner = new ProgressSpinner();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                CenterPaneController.this.table.getSelectionModel().selectAll();
                ObservableList selectedIndices = CenterPaneController.this.table.getSelectionModel().getSelectedIndices();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                ArrayList<Callable<Object>> futures = new ArrayList<Callable<Object>>(selectedIndices.size());
                for (Integer i : selectedIndices) {
                    futures.add(Executors.callable(() -> {
                        try {
                            DPXFileInformationViewModel fivm = (DPXFileInformationViewModel)CenterPaneController.this.table.getItems().get(i.intValue());
                            DPXFileListHelper.updateValues(changedValues, fivm);
                        }
                        catch (Exception e) {
                            System.out.println("Update values error");
                        }
                    }));
                }
                try {
                    executor.invokeAll(futures);
                }
                catch (InterruptedException e) {
                    System.out.println("Update values thread error");
                }
                CenterPaneController.this.selectedFilesSummary = TableState.isSelectAll() ? DPXFileListHelper.createSelectedFilesSummaryAll() : DPXFileListHelper.createSelectedFilesSummary((List<DPXFileInformationViewModel>)CenterPaneController.this.table.getSelectionModel().getSelectedItems());
                CenterPaneController.this.setSelectedRuleSets(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            this.table.refresh();
            this.refreshEditor(false);
            spinner.getDialogStage().hide();
            Platform.runLater(() -> this.showEditsAlert(changedValues.size()));
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    private void updateData() {
        boolean sa = TableState.isSelectAll();
        DPXFileListHelper.setSelectAll(sa);
        if (TableState.getDeleteFiles()) {
            ObservableList<DPXFileInformationViewModel> toDelete = ControllerMediatorDPX.getInstance().getSelectedFileList();
            DPXFileListHelper.deleteSelectedRows(toDelete);
            this.selectedFilesSummary = null;
        }
        if (TableState.getUpdateSummary() && !TableState.isUpdatingSummary()) {
            TableState.setUpdatingSummary(true);
            this.selectedFilesSummary = DPXFileListHelper.createSelectedFilesSummary((List<DPXFileInformationViewModel>)this.table.getSelectionModel().getSelectedItems());
            this.selectedFilesSummary.setValidRuleSets(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
            TableState.setUpdateSummary(false);
            TableState.setUpdatingSummary(false);
        }
    }

    private void updateTable() {
        if (TableState.getDeleteFiles()) {
            ControllerMediatorDPX.getInstance().getSelectedFileList();
            ControllerMediatorDPX.getInstance().setFileList();
            this.table.getSelectionModel().clearSelection();
            TableState.setDeleteFiles(false);
        } else if (TableState.isSelectAll()) {
            try {
                this.tableSelectionModel.selectAll();
            }
            catch (Exception ex) {
                System.out.println("Caught exception attempting to select all items in table");
            }
        } else if (TableState.getDeselectAll()) {
            this.tableSelectionModel.clearSelection();
            TableState.setDeselectAll(false);
        }
        if (TableState.getUpdateEditor()) {
            int selectedRowCount = this.table.getSelectionModel().getSelectedItems().size();
            if (selectedRowCount > 0 && this.selectedSection != null) {
                ControllerMediatorDPX.getInstance().setEditor(this.selectedSection);
            } else if (selectedRowCount > 0) {
                ControllerMediatorDPX.getInstance().resetEditor(this.selectedSection);
                ControllerMediatorDPX.getInstance().setGeneralEditor();
            } else {
                ControllerMediatorDPX.getInstance().resetEditor(this.selectedSection);
            }
            TableState.setUpdateEditor(false);
        }
    }

    private void setSequenceErrorLists() {
        List<DPXSequenceError> sequenceErrors = DPXBatchProcessor.getSequenceErrorList((ObservableList<DPXFileInformationViewModel>)this.getTable().getItems(), false);
        this.filenameSequenceErrorList.clear();
        this.imageFilenameSequenceErrorList.clear();
        this.sourceImageFilenameSequenceErrorList.clear();
        this.framePositionSequenceErrorList.clear();
        for (DPXSequenceError seqError : sequenceErrors) {
            if (seqError.getColumn() == "Filename") {
                this.filenameSequenceErrorList.add(seqError);
            }
            if (seqError.getColumn() == "Image Filename") {
                this.imageFilenameSequenceErrorList.add(seqError);
            }
            if (seqError.getColumn() == "Source Image Filename") {
                this.sourceImageFilenameSequenceErrorList.add(seqError);
            }
            if (seqError.getColumn() != "Frame Position in Sequence") continue;
            this.framePositionSequenceErrorList.add(seqError);
        }
    }

    public void autoPopulateNames() {
        String message = "Are you sure you want to change the Image Filename metadata to match the Filename on disk?";
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Are you sure?", Alert.AlertType.CONFIRMATION, "Are you sure you want to change the Image Filename metadata to match the Filename on disk?", new ButtonType[0]);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        alert.setGraphic(null);
        alert.setHeaderText(null);
        DialogPane dialogPane = alert.getDialogPane();
        alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp("Are you sure you want to change the Image Filename metadata to match the Filename on disk?");
        dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            ProgressSpinner spinner = new ProgressSpinner();
            Task<Void> task = new Task<Void>(){

                public Void call() throws InterruptedException {
                    ObservableList selectedIndices = CenterPaneController.this.table.getSelectionModel().getSelectedIndices();
                    ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    ArrayList<Callable<Object>> futures = new ArrayList<Callable<Object>>(selectedIndices.size());
                    for (Integer i : selectedIndices) {
                        futures.add(Executors.callable(() -> {
                            try {
                                DPXFileInformationViewModel fivm = (DPXFileInformationViewModel)CenterPaneController.this.table.getItems().get(i.intValue());
                                DPXFileListHelper.updateName(fivm);
                            }
                            catch (Exception e) {
                                System.out.println("Error updating filenames");
                            }
                        }));
                    }
                    try {
                        executor.invokeAll(futures);
                    }
                    catch (InterruptedException e) {
                        System.out.println("Thread error");
                    }
                    CenterPaneController.this.setSelectedRuleSets(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
                    TableState.setUpdateEditor(true);
                    TableState.setUpdateSummary(true);
                    CenterPaneController.this.updateData();
                    return null;
                }
            };
            task.setOnSucceeded(event -> {
                Platform.runLater(() -> {
                    this.table.refresh();
                    this.updateTable();
                });
                spinner.getDialogStage().hide();
            });
            Thread thread = new Thread((Runnable)task);
            thread.start();
            spinner.getDialogStage().show();
            this.refreshEditor(true);
        }
    }

    public void clearFilterByViolations() {
        this.table.setItems(DPXFileListHelper.getObservableFileList());
    }

    private List<CheckBox> createColumnVisibilityCheckBoxes() {
        ArrayList<CheckBox> cbList = new ArrayList<CheckBox>();
        final HashMap relatedColumnDictionary = new HashMap();
        final HashMap<String, Object> checkboxIdToColumnKeyMap = new HashMap<String, Object>();
        Integer count = 0;
        for (TableColumn col : this.table.getColumns()) {
            Object text = col.getId();
            if (((String)text).length() > 20) {
                text = ((String)text).substring(0, 20) + "...";
            }
            CheckBox checkbox = new CheckBox((String)text);
            Tooltip tt = new Tooltip(col.getId());
            String ttStyle = "-fx-font-size: 12px";
            tt.setStyle("-fx-font-size: 12px");
            checkbox.setTooltip(tt);
            checkbox.setId(count.toString());
            if (col.getUserData() instanceof String) {
                String data = (String)col.getUserData();
                ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
                columnList.add(col);
                relatedColumnDictionary.put(data, columnList);
                checkbox.setUserData(col.getUserData());
                checkboxIdToColumnKeyMap.put(checkbox.getId(), data);
            } else {
                Object columnKey;
                DPXMetadataColumnViewModel mcvm = (DPXMetadataColumnViewModel)col.getUserData();
                if (mcvm.getHasSubsection().booleanValue()) {
                    columnKey = mcvm.getSubsectionName();
                    List existingColumnList = (List)relatedColumnDictionary.get(columnKey);
                    if (existingColumnList != null) {
                        existingColumnList.add(col);
                        continue;
                    }
                    checkbox.setText(mcvm.getSubsectionName());
                    Tooltip updatedTooltip = new Tooltip(mcvm.getSubsectionName());
                    updatedTooltip.setStyle("-fx-font-size: 12px");
                    checkbox.setTooltip(updatedTooltip);
                } else {
                    columnKey = col.getId() + mcvm.hashCode();
                }
                checkbox.setUserData((Object)mcvm.getSectionDisplayName());
                checkboxIdToColumnKeyMap.put(checkbox.getId(), columnKey);
                ArrayList<TableColumn> columnList = new ArrayList<TableColumn>();
                columnList.add(col);
                relatedColumnDictionary.put(columnKey, columnList);
            }
            if (!this.userHiddenColumns.contains(col)) {
                checkbox.setSelected(true);
            } else {
                checkbox.setSelected(false);
            }
            cbList.add(checkbox);
            Integer n = count;
            count = count + 1;
        }
        for (final CheckBox checkbox : cbList) {
            checkbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
                    String columnKey = (String)checkboxIdToColumnKeyMap.get(checkbox.getId());
                    List columns = (List)relatedColumnDictionary.get(columnKey);
                    UserPreferencesService userPreferences = new UserPreferencesService();
                    for (TableColumn col : columns) {
                        if (nv.booleanValue()) {
                            CenterPaneController.this.userHiddenColumns.remove(col);
                            userPreferences.removeHiddenDPXColumn(col.getId());
                            continue;
                        }
                        CenterPaneController.this.userHiddenColumns.add(col);
                        userPreferences.addHiddenDPXColumn(col.getId());
                    }
                }
            });
        }
        return cbList;
    }

    public void deleteSelectedFiles() {
        ProgressSpinner spinner = new ProgressSpinner();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                TableState.setDeleteFiles(true);
                CenterPaneController.this.updateData();
                Platform.runLater(() -> CenterPaneController.this.updateTable());
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            spinner.getDialogStage().hide();
            ControllerMediatorDPX.getInstance().setFiles();
        });
        spinner.activateProgressBar(task);
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    public void deselectAllFiles() {
        ProgressSpinner spinner = new ProgressSpinner();
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                DPXFileListHelper.setSelectAll(false);
                TableState.setSelectAll(false);
                TableState.setDeselectAll(true);
                TableState.setUpdateSummary(true);
                TableState.setUpdateEditor(true);
                CenterPaneController.this.updateData();
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            Platform.runLater(() -> this.updateTable());
            spinner.getDialogStage().hide();
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    public int filterByViolations() {
        FilteredList filteredList = new FilteredList(this.table.getItems());
        filteredList.setPredicate((Predicate)new Predicate<DPXFileInformationViewModel>(this){

            @Override
            public boolean test(DPXFileInformationViewModel t) {
                return t.hasError(ControllerMediatorDPX.getInstance().getCurrentRuleSets());
            }
        });
        this.table.setItems((ObservableList)filteredList);
        return filteredList.size();
    }

    public ObservableList<DPXFileInformationViewModel> getSelectedFiles() {
        ObservableList list = this.table.getSelectionModel().getSelectedItems();
        return list;
    }

    public SelectedFilesSummary getSelectedFilesSummary() {
        return this.selectedFilesSummary;
    }

    public TableView<DPXFileInformationViewModel> getTable() {
        return this.table;
    }

    public int getTableSize() {
        return this.table.getItems().size();
    }
}

