/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.IFileValidationRule;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.IsValidIntRangeRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;

public class DPXImageDataSignRule
implements IFileValidationRule {
    DPXColumn targetColumn;
    boolean isValid;
    int imageElement = 1;
    private final String valid32 = "Must be valid unsigned 32bit integer";
    private final String smc = "SMPTE-C \n\n";

    public DPXImageDataSignRule(DPXColumn column, int imageElement) {
        this.targetColumn = column;
        this.imageElement = imageElement;
    }

    @Override
    public String getRule() {
        return "SMPTE-C \n\nMust be valid unsigned 32bit integer; can be values of 0 or 1 only; values 2-255 are not allowed";
    }

    @Override
    public ValidationRuleSetEnum getRuleSet() {
        return ValidationRuleSetEnum.SMPTE_C;
    }

    @Override
    public DPXColumn getTargetColumn() {
        return this.targetColumn;
    }

    @Override
    public IValidationRule getValidationRule() {
        return new IsValidIntRangeRule(0, 1);
    }

    @Override
    public boolean isValid(DPXFileInformationViewModel file) {
        String imageElements = file.getProp(DPXColumn.NUMBER_OF_IMAGE_ELEMENTS);
        if (imageElements.isEmpty()) {
            return true;
        }
        try {
            if (Integer.parseInt(imageElements) < this.imageElement) {
                return true;
            }
        }
        catch (NumberFormatException ex) {
            return true;
        }
        String value = file.getProp(this.targetColumn);
        IValidationRule rule = this.getValidationRule();
        return rule.isValid(value);
    }
}

