/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.dpx;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.BinaryFileReader;
import com.portalmedia.embarc.parser.ByteOrderEnum;
import com.portalmedia.embarc.parser.MetadataColumn;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import com.portalmedia.embarc.parser.dpx.DPXMetadataColumnFactory;
import com.portalmedia.embarc.parser.dpx.DPXSection;
import java.io.FileNotFoundException;

public class DPXService {
    String filePath;

    /*
     * Exception decompiling
     */
    public static boolean writeFile(DPXFileInformationViewModel file, String inputPath, String outputPath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DPXService(String filePath) throws FileNotFoundException {
        this.filePath = filePath;
    }

    public DPXMetadata readFile() throws Exception {
        try (BinaryFileReader dpxFile = new BinaryFileReader(this.filePath);){
            MetadataColumn mdColumn;
            ByteOrderEnum byteOrder = ByteOrderEnum.BIG;
            DPXMetadata dpxData = new DPXMetadata();
            byte[] emptyBA = new byte[]{};
            for (DPXColumn dPXColumn : DPXSection.FILE_INFORMATION_HEADER.getColumns()) {
                byte[] bytes = dpxFile.readBytes(dPXColumn.getLength());
                mdColumn = DPXMetadataColumnFactory.create(dPXColumn, bytes, byteOrder);
                if (dPXColumn == DPXColumn.MAGIC_NUMBER && !mdColumn.toString().equals("SDPX")) {
                    if (mdColumn.toString().equals("XPDS")) {
                        byteOrder = ByteOrderEnum.LITTLE;
                        mdColumn = DPXMetadataColumnFactory.create(DPXColumn.MAGIC_NUMBER, bytes, byteOrder);
                    } else {
                        throw new IllegalArgumentException("Invalid magic number");
                    }
                }
                dpxData.setValue(mdColumn);
            }
            int industrySpecificHeaderLength = dpxData.getColumn(DPXColumn.INDUSTRY_SPECIFIC_HEADER_LENGTH).getInt();
            for (DPXColumn c : DPXSection.IMAGE_INFORMATION_HEADER.getColumns()) {
                mdColumn = DPXMetadataColumnFactory.create(c, dpxFile.readBytes(c.getLength()), byteOrder);
                dpxData.setValue(mdColumn);
            }
            for (DPXColumn c : DPXSection.IMAGE_SOURCE_INFORMATION_HEADER.getColumns()) {
                mdColumn = DPXMetadataColumnFactory.create(c, dpxFile.readBytes(c.getLength()), byteOrder);
                dpxData.setValue(mdColumn);
            }
            if (industrySpecificHeaderLength > 0) {
                for (DPXColumn c : DPXSection.MOTION_PICTURE_FILM_INFORMATION_HEADER.getColumns()) {
                    mdColumn = DPXMetadataColumnFactory.create(c, dpxFile.readBytes(c.getLength()), byteOrder);
                    dpxData.setValue(mdColumn);
                }
                for (DPXColumn c : DPXSection.TELEVISION_INFORMATION_HEADER.getColumns()) {
                    mdColumn = DPXMetadataColumnFactory.create(c, dpxFile.readBytes(c.getLength()), byteOrder);
                    dpxData.setValue(mdColumn);
                }
            } else {
                for (DPXColumn c : DPXSection.MOTION_PICTURE_FILM_INFORMATION_HEADER.getColumns()) {
                    mdColumn = DPXMetadataColumnFactory.create(c, emptyBA, byteOrder);
                    dpxData.setValue(mdColumn);
                }
                for (DPXColumn c : DPXSection.TELEVISION_INFORMATION_HEADER.getColumns()) {
                    mdColumn = DPXMetadataColumnFactory.create(c, emptyBA, byteOrder);
                    dpxData.setValue(mdColumn);
                }
            }
            int n = DPXColumn.USER_IDENTIFICATION.getLength();
            int lengthOfUserData = Math.max(dpxData.getColumn(DPXColumn.USER_DEFINED_HEADER_LENGTH).getInt() - n, 0);
            if (lengthOfUserData > 0) {
                user = DPXMetadataColumnFactory.create(DPXColumn.USER_IDENTIFICATION, dpxFile.readBytes(n), byteOrder);
                dpxData.setValue(user);
                MetadataColumn userDefinedData = DPXMetadataColumnFactory.create(DPXColumn.USER_DEFINED_DATA, dpxFile.readBytes(lengthOfUserData), byteOrder);
                dpxData.setValue(userDefinedData);
            } else {
                user = DPXMetadataColumnFactory.create(DPXColumn.USER_IDENTIFICATION, emptyBA, byteOrder);
                dpxData.setValue(user);
                MetadataColumn userDefinedData = DPXMetadataColumnFactory.create(DPXColumn.USER_DEFINED_DATA, emptyBA, byteOrder);
                dpxData.setValue(userDefinedData);
            }
            DPXMetadata dPXMetadata = dpxData;
            return dPXMetadata;
        }
    }
}

