/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.dpx;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import com.portalmedia.embarc.validation.CustomValidationRuleResult;
import java.io.Serializable;
import java.util.List;
import org.dizitart.no2.objects.Id;

public class DPXFileInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String path;
    private boolean edited;
    @Id
    private int id;
    private DPXMetadata fileData;
    private List<CustomValidationRuleResult> validationResults;

    public DPXFileInformation() {
    }

    public DPXFileInformation(String name, String path, int id) {
        this.name = name;
        this.path = path;
        this.id = id;
    }

    public boolean getEdited() {
        return this.edited;
    }

    public DPXMetadata getFileData() {
        return this.fileData;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getOffsetToImageData() {
        String userDefinedData = this.getValue(DPXColumn.USER_DEFINED_DATA);
        int totalMetadata = 0;
        int userDefintedDataLength = userDefinedData.length();
        for (DPXColumn column : DPXColumn.values()) {
            if (column == DPXColumn.USER_DEFINED_DATA) continue;
            totalMetadata += column.getLength();
        }
        int total = totalMetadata + userDefintedDataLength;
        return total;
    }

    public String getPath() {
        return this.path;
    }

    public String getValue(ColumnDef column) {
        return this.fileData.getColumn(column).toString();
    }

    public void setFileData(DPXMetadata data) {
        this.fileData = data;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void updateData(ColumnDef column, String value) {
        this.edited = true;
        this.fileData.setValue(column, value);
    }

    public List<CustomValidationRuleResult> getValidationResults() {
        return this.validationResults;
    }

    public void setValidationResults(List<CustomValidationRuleResult> validationResults) {
        this.validationResults = validationResults;
    }
}

