/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.AccessibleRole;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;

public class WorkingSummaryController
implements Initializable {
    @FXML
    private Label totalFilesLabel;
    @FXML
    private Label filesSelectedLabel;
    @FXML
    private Label selectAllFilesLabel;
    @FXML
    private Label deselectAllFilesLabel;
    @FXML
    private Label removeSelectedFilesLabel;
    @FXML
    private CheckBox errorsOnlyCheckBox;

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorDPX.getInstance().registerWorkingSummaryController(this);
        this.removeSelectedFilesLabel.setVisible(false);
        this.errorsOnlyCheckBox.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Boolean isChecked = WorkingSummaryController.this.errorsOnlyCheckBox.selectedProperty().get();
                int numFilesWithErrors = ControllerMediatorDPX.getInstance().toggleErrorsOnlyFilter(isChecked);
                if (isChecked.booleanValue()) {
                    WorkingSummaryController.this.errorsOnlyCheckBox.setText("Errors Only: " + numFilesWithErrors);
                } else {
                    WorkingSummaryController.this.errorsOnlyCheckBox.setText("Errors Only");
                }
                DPXFileListHelper.setSelectAll(false);
                WorkingSummaryController.this.setSelectedFileList(null);
            }
        });
        this.totalFilesLabel.setAccessibleText("Total number of files imported.");
        this.totalFilesLabel.setFocusTraversable(true);
        this.filesSelectedLabel.setAccessibleText("Total number of files currently selected.");
        this.filesSelectedLabel.setFocusTraversable(true);
        this.selectAllFilesLabel.setAccessibleText("Select all files.");
        this.selectAllFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.selectAllFilesLabel.setFocusTraversable(true);
        this.selectAllFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.selectAllFilesLabel.setOnMouseClicked(event -> ControllerMediatorDPX.getInstance().selectAllFiles());
        this.selectAllFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorDPX.getInstance().selectAllFiles();
        });
        this.deselectAllFilesLabel.setAccessibleText("Deselect all files.");
        this.deselectAllFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.deselectAllFilesLabel.setFocusTraversable(true);
        this.deselectAllFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.deselectAllFilesLabel.setOnMouseClicked(event -> ControllerMediatorDPX.getInstance().deselectAllFiles());
        this.deselectAllFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorDPX.getInstance().deselectAllFiles();
        });
        this.removeSelectedFilesLabel.setAccessibleText("Remove all selected files.");
        this.removeSelectedFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.removeSelectedFilesLabel.setFocusTraversable(true);
        this.removeSelectedFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.removeSelectedFilesLabel.setOnMouseClicked(event -> ControllerMediatorDPX.getInstance().deleteSelectedFiles());
        this.removeSelectedFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorDPX.getInstance().deleteSelectedFiles();
        });
        this.errorsOnlyCheckBox.setAccessibleText("Only show files with errors.");
        this.errorsOnlyCheckBox.setFocusTraversable(true);
    }

    public void resetErrorCount() {
        Platform.runLater(() -> {
            Boolean isChecked = this.errorsOnlyCheckBox.selectedProperty().get();
            if (isChecked.booleanValue()) {
                int numFilesWithErrors = ControllerMediatorDPX.getInstance().getCurrentFileCount();
                this.errorsOnlyCheckBox.setText("Errors Only: " + numFilesWithErrors);
            } else {
                this.errorsOnlyCheckBox.setText("Errors Only");
            }
        });
    }

    public <T> void setFiles() {
        long size = DPXFileListHelper.getTotalFiles();
        if (size >= 1L) {
            String text = Long.toString(size) + " file" + (size == 1L ? " " : "s ") + "imported";
            this.totalFilesLabel.setText(text);
            this.totalFilesLabel.setAccessibleText(text);
            this.selectAllFilesLabel.setVisible(true);
            this.deselectAllFilesLabel.setVisible(true);
        } else {
            this.totalFilesLabel.setText(Long.toString(size) + " files imported");
            this.totalFilesLabel.setAccessibleText(Long.toString(size) + " files imported");
            this.selectAllFilesLabel.setVisible(false);
            this.deselectAllFilesLabel.setVisible(false);
        }
    }

    public <T> void setSelectedFileList(ObservableList<DPXFileInformationViewModel> list) {
        long size;
        long l = size = list == null ? 0L : DPXFileListHelper.getSelectedFileCount(list, ControllerMediatorDPX.getInstance().getCurrentRuleSets(), this.errorsOnlyCheckBox.isSelected());
        if (size >= 1L) {
            String text = Long.toString(size) + " file" + (size == 1L ? " " : "s ") + "selected";
            this.filesSelectedLabel.setText(text);
            this.filesSelectedLabel.setAccessibleText(text);
            this.deselectAllFilesLabel.setVisible(true);
            this.removeSelectedFilesLabel.setVisible(true);
        } else {
            this.filesSelectedLabel.setText(Long.toString(size) + " files selected");
            this.filesSelectedLabel.setAccessibleText(Long.toString(size) + " files selected");
            this.selectAllFilesLabel.setVisible(true);
            this.deselectAllFilesLabel.setVisible(false);
            this.removeSelectedFilesLabel.setVisible(false);
        }
    }
}

