---
layout: post
title: Cleaning and Maintenance
---

# Maintenance & Cleaning

## Cleaning supplies

(View this as a [poster]({{ site.baseurl }}/images/DVRescue_Shopping_List_Cleaning.pdf)!)

### alcohol - denatured or isopropyl (99%) 

<img alt="alcohol" src="{{ site.baseurl }}/images/alcohol.png">  

Isopropyl alcohol (with a concentration lower than 99%) and rubbing alcohol (even 91%) contain additives that leave a residue and take longer to dry. Denatured alcohol and isopropyl (99%) are cheap, clean and effective. You can find both at your local hardware, hypermarket store or online.
  
<br>
### head cleaning swabs

<img alt="head cleaning swabs" src="{{ site.baseurl }}/images/head_cleaning_swabs.png">  

There are several options for swabs used to clean video deck heads. The pointed ones are helpful for grooves and ridges that collect tape debris (but make sure the cotton is firmly packed, like a surgical swab vs. a standard Q-tip). The Chamois swabs work well for gently cleaning dirty tape heads, but you can also use Texwipe 304 clothes as well. Clothes help to prevent you from breaking or damaging the heads. For DV decks, since the parts are so small, the swabs are easier to maneuver carefully.

### head cleaning tape

<img alt="DV head cleaning tape" src="{{ site.baseurl }}/images/head_cleaning_tape.png">   

DV and Digital8 cleaning cassettes using a white or green long-fiber paper material named Pellon is the easiest way to clean DV decks and works well for light/regular cleaning. For a heavily contaminated or dirty deck, you’ll want to manually clean it with the supplied listed above. A/V archivists are still a divided on the use of cleaning tapes. In general, as long as the cleaning tapes are only used once (beginning to end) and only as instructed, there shouldn’t be a problem. However, once a cleaning tape has passed along the heads, the dirt/debris it collects can damage the tape heads if it is run through the deck again.

We reccomend using a cleaning tape for DV and Digital8 camcorders because they are more difficult to deassemble/reassemble. Cleaning tapes can be purchased on Amazon and through some AV retailers. 

For detailed instructions and training videos on cleaning decks, please see the “Deck Inspection & Cleaning” section (coming soon).


## Repair supplies

(View this as a [poster]({{ site.baseurl }}/images/DVRescue_Shopping_List_Repairs.pdf)!)

### 1.4mm Philips screwdriver

<img alt="screwdriver" src="{{ site.baseurl }}/images/onePointFourmm_Phillips_Screwdriver.png">  

This screwdriver is compatible with the screws securing the cassette shells for DV formats. If a tape breaks or is contaminated, you will need to use this to open the cassette and perform repairs or cleaning. Often, the screwdriver that came with an eyeglasses repair kit will be the correct size.

### micro-tip sewing scissors

<img alt="micr-tip sewing scissors" src="{{ site.baseurl }}/images/scissors.png">

Sharp scissors meant for precision trimming work perfectly to splice a damaged DV tape.

### razor blade

<img alt="razor blade" src="{{ site.baseurl }}/images/razorblade.png">

A sharp razor blade also works for splicing. It really comes down to your preference and the type of repair you are performing. Either tool needs to be very sharp to be accurate and effective.


### 1/4” splicing block

<img alt="1/4” splicing block" src="{{ site.baseurl }}/images/splicingblock.png">

A splicing block acts as a guide for both cutting and taping during a splice. The center tape channel secures tape during use.

### 1/4” splicing tape

<img alt="1/4” splicing tape" src="{{ site.baseurl }}/images/splicingtape.png">

It is important to use tape that is designed for magnetic media when repairing audio or videotape. It is specifically designed to resist age and stress. The adhesive is non-acidic to prevent the tape from breaking down or contaminating the magnetic media materials. The same tape used for splicing 1/4” audiotape can be used for DV. You can buy splicing tape, splicing blocks and razor blades in a kit from a variety of retailers.

For detailed instructions and training videos on spotting and repairing, please see the “DV Tape Repairs” and “Tape Inspections” sections.
