---
layout: post
title: Deck Guide
---


# Decks (Overview)

[View this table in Google Sheets](https://docs.google.com/spreadsheets/d/1HvNsC110aBH8WjfnNJrF6KlT2STgCT5KRBaf1g6MxGQ/edit?usp=sharing)

| Image | Make | Model | Compatible Formats | Compatible Sizes | Non-compatible Formats | Standard | SP/LP modes | Operation Manual | Service Manual | Power | Cable/Output | Remote 9-pin? | Known Issues/<br/>Unique Characteristics | Known Issues/<br/>Unique Characteristics | Known Issues/<br/>Unique Characteristics |
| ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- | ------------- |
| [![JVC BR-DV6000U](https://mipops.github.io/dvrescue/images/JVC_BR-DV6000.png){:width="300px"}](https://drive.google.com/file/d/1hwV4cXKTYx5cv_OxlIBUJo0ulKr2CxQ9/view) | JVC | BR-DV6000U | DVCAM; DV; MiniDV | standard and mini sizes | HDV; DVCPRO; DVCPRO50; EP/LP | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1WHUPZllSSey4_JpthZznFUGdRWFoWEa4/view?usp=sharing) |  | DC IN 12V | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | yes |
| [![Sony DSR-1500A/DSR-1500AP](https://mipops.github.io/dvrescue/images/Sony_DSR-1500A.png){:width="300px"}](https://drive.google.com/file/d/1lhkLrlu8ZfTvh0_0T3KfAQIUGT2idiw6/view) | Sony | DSR-1500A/DSR-1500AP | DV; MiniDV; DVCAM; DVCPRO | standard and mini sizes, L and M sizes of DVCPRO | HDV; DVCPRO; DVCPRO50; EP/LP | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1nXwG5qYRxtWYIDFPjOfrvjR5qrIkbItM/view?usp=sharing) | [Link](https://drive.google.com/file/d/1Wa-OX_OLy_NwtHbYwWj9UMLTaraT1pxA/view?usp=sharing) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | To ensure compatibility with DVRescue, avfctl, and vrecord, make sure that Video input is set to iLink vs. 9-pin (in Setp-up Menu/Video Output) and that the Video output on the main display is set to "SG" (vs. "iLink") by clicking the "Video" button on the front panel of the deck (push the button until it displays "SG SG SG"). Built-into the DSR-1500A VTR is the i.LINK interface, which is based upon the IEEE1394 (DV, Firewire) standard. The i.LINK enables a single cable to simultaneously carry digital video and audio signals, as well as data and control signals with virtually no quality degradation. This simple connection offers an ideal solution for connecting the DSR-1500A with i.LINK interface equipped compatible nonlinear editing systems and other computer-related products. Make sure that you hit the SET button after changing any of the settings. The display should read "Saving..." and then exit the menu. | **LOCAL/REMOTE switch:** Selects whether the unit is operated from its front panel or  from external equipment. REMOTE: The unit is operated from external equipment  connected to the REMOTE connector or i.DV IN/ OUT connector on the rear panel. LOCAL: The unit is operated from its front panel or from  a SIRCS-compatible remote control unit connected to  the CONTROL S connector on the front panel. If the LOCAL/REMOTE switch is set to REMOTE, the  COUNTER SELECT button does not operate while the  tape is moving. In this case, make the time data selection  via the external equipment connected to the REMOTE  connector on the rear panel. | **REMOTE I/F [> Remote I/F]:** When remote-controlling this unit with the LOCAL/REMOTE switch set to REMOTE, select either the REMOTE connector or i.DV IN/OUT connector (optional DSBK-1501 board required) for connecting a remote control unit. |
| [![Sony DSR-1800](https://mipops.github.io/dvrescue/images/Sony_DSR-1800.png){:width="300px"}](https://drive.google.com/file/d/1hqUXqy1GHt7JtVDNOg_dLSEYLwFf2y_J/view) | Sony | DSR-1800 | DVCAM; MiniDV; DVCPRO; DV | standard and mini sizes, L and M sizes of DVCPRO | HDV; DVCPRO50; EP/LP | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1GNyF9PrF-8dRdytK4FvXDCpV4uXRL_8N/view?usp=sharing) | [Link](https://drive.google.com/file/d/1pE-XoqvMRxnOrdN2NzEbzoV4y3h9W1pH/view?usp=sharing) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. A common kit that was purchased from Sony option kit Sony DSBK-190 (which is no longer available from Sony). | When playing back a tape recorded in DVCPRO (25M) format, the SDTI and i.LINK outputs (see “Digital interfaces” on page 10) of this unit are muted. Furthermore, it is not possible to play back the cue-audio track of the tape. --from operation manual | A tape recorded in LP mode cannot be played back correctly. When a tape recorded in LP mode is played back, “DV LP” flashes and audio is muted (see page 18). |
| [![Sony DSR-2000/DSR-2000AP/DSR-2000P](https://mipops.github.io/dvrescue/images/Sony_DSR-2000.png){:width="300px"}](https://drive.google.com/file/d/1qbkt5eVANWVxf9v1BgLv20vn8_mwrHfT/view) | Sony | DSR-2000/DSR-2000AP/DSR-2000P | DV; DVCAM; MiniDV; DVCPRO (playback only via FireWire, capture only via analog cables) | standard and mini sizes, L and M sizes of DVCPRO | HDV; DVCPRO (via FireWire); DVCPRO50; DVCPRO HD | NTSC | SP/LP  | [Link](https://drive.google.com/file/d/1v4dlbRi4C_y1qLH-4d30w1chZOS7X_zE/view?usp=sharing) | [Link](https://drive.google.com/file/d/1GSCG0vdB4bdrwukkvgdrW09SpFrgJYjN/view?usp=sharing) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. A common kit that was purchased from Sony option kit Sony DSBK-190 (which is no longer available from Sony). |
| [![Sony DSR-2000A/DSR-2000AP](https://mipops.github.io/dvrescue/images/Sony_DSR-2000AP.png){:width="300px"}](https://drive.google.com/file/d/1g58BxR9qIQ2f57uIMkRUUTkYgiMPGdtH/view) | Sony | DSR-2000A/DSR-2000AP | DV; DVCAM; MiniDV; DVCPRO (playback only via FireWire, capture only via analog cables) | standard and mini sizes, L and M sizes of DVCPRO | HDV; DVCPRO (via FireWire); DVCPRO50; DVCPRO HD | NTSC | SP/LP  | [Link](https://drive.google.com/file/d/1FGsVfi8nNcq0L5ti3wQNgBDtauVBU4QF/view?usp=sharing) | [Link](https://data2.manualslib.com/pdf7/201/20052/2005163-sony/dsr2000a.pdf?5ea96dfd0de42c09611bfbe0dd833cc5) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. A common kit that was purchased from Sony option kit Sony DSBK-190 (which is no longer available from Sony). |
| [![Sony DSR-1000](https://mipops.github.io/dvrescue/images/Sony_DSR-DR1000.png){:width="300px"}](https://drive.google.com/file/d/1_myuNU4AMISauHXJfCfWXj0lfJ3SxFIH/view) | Sony | DSR-1000 | DVCAM |  | HDV or DVCPRO | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1fwbSL_6ICe0JZV_vxrF7KkNrsRBHm75L/view?usp=drive_link) | [Link](https://data2.manualslib.com/pdf6/134/13315/1331470-sony/dsrdr1000.pdf?4ebaad8933648d78dda5d8d493d7aa50) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. A common kit that was purchased from Sony option kit Sony DSBK-190 (which is no longer available from Sony). |
| [![Sony DSR-45/DSR-45P](https://mipops.github.io/dvrescue/images/Sony_DSR-45A.png){:width="300px"}](https://drive.google.com/file/d/1-QOVbAeVA24_EOKg0_8OM7mgEjG_d4Pd/view) | Sony | DSR-45/DSR-45P | DV/MiniDV; DVCAM | standard and mini sizes only | HDV; LP | NTSC | SP mode only (although some users have reported being able to playback and capture LP tapes using this model) | [Link](https://drive.google.com/file/d/1PrTT0m773zr5MOKSMvpotIeCTpddsG4K/view?usp=sharing) | [Link](https://drive.google.com/file/d/1TslKI8cI_G9POZSBEnE_q5VkrC7KkoBG/view?usp=sharing) | AC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | yes |
| [![Sony HVR-M15U](https://mipops.github.io/dvrescue/images/Sony_HVR-M15U.jpg){:width="300px"}](https://drive.google.com/file/d/1dA1icY-QdgbXrd9DaOJu7IF9HjJUW9Ay/view) | Sony | HVR-M15U | HDV; DV/MiniDV; DVCAM | standard and mini sizes only | LP | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1VhdLASHbCTBx5g-SqnkJEQB8Qb1dv2oV/view?usp=sharing) | [Link](https://drive.google.com/file/d/1hmNn68Qk8Y9STG6svNUGZmKfln2yG4dI/view?usp=sharing) | DC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | no | Since DVRescue does not currently support transferring HDV (you can capture video only with vrecord and DVRescue, but no audio, even if it is present on the tape), you can capture it with either DVHSCap (if your computer is old enough) from the FireWireSDK toolkit, or with Quicktime. In order to capture both video and audio (using QuickTime) for HDV, use [these settings (access via the deck menu)](https://drive.google.com/drive/folders/1BF1gGzCoxtyxH5gljHj0dOdEM89UJB12?usp=sharing) |
| [![Sony HVR-M25U](https://mipops.github.io/dvrescue/images/Sony_HVR-M25U.png){:width="300px"}](https://drive.google.com/file/d/1Xxh4S2zuBb3dqUnyWOaBmOWP5uJw90jL/view) | Sony | HVR-M25U | HDV; MiniDV; DVCAM |  | LP | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1Q2tvOp3YlATwyvUDuyF5kIyWUwNO-qg-/view?usp=sharing) |  | AC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | no | Since DVRescue does not currently support transferring HDV (you can capture video only with vrecord and DVRescue, but no audio, even if it is present on the tape), you can capture it with either DVHSCap (if your computer is old enough) from the FireWireSDK toolkit, or with Quicktime. In order to capture both video and audio (using QuickTime) for HDV, use [these settings (access via the deck menu)](https://drive.google.com/drive/folders/1BF1gGzCoxtyxH5gljHj0dOdEM89UJB12?usp=sharing). |
| [![Sony DSR-11](https://mipops.github.io/dvrescue/images/Sony_DSR-11.png){:width="300px"}](https://drive.google.com/file/d/1xI2KUFKU-ziPSFFwrwNigmK1jmWb9shq/view) | Sony | DSR-11 | MiniDV; DVCAM | standard and mini sizes only | LP | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1F9WiWOWM96PjRgyq6llyabWJZ3BYaY0N/view?usp=sharing) |  | DC IN 12V | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | no |
|  | Panasonic | AJ-D250 | DVCPRO | medium; large/standard |  | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1hEhEHsxd-La2jAgcvNOkkDtyv116MDDx/view?usp=sharing) |  | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) |  | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. |
|  | Panasonic | AJ-D440 | DV; DVCAM; DVCPRO; DVCPRO50 | medium; large/standard | MiniDV, LP | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1-Rw0ZD3nGAmlOjtO5r4LJsicEtr6a-Ya/view?usp=sharing) | [Link](https://drive.google.com/file/d/10N34qK7P8xw9U1DBYcbWvpdU4a-f3jjt/view?usp=sharing) | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) |  | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. |
|  | Panasonic | AJ-D455 | DV; DVCAM; DVCPRO; DVCPRO50 | medium; large/standard | MiniDV, LP | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1SMqZ9byCKxYWmAntLz51xfc4Yw5iaXp_/view?usp=sharing) |  | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) |  | These decks were manufactured without a FireWire port, but users could add them to the deck with kits from the manufacturer. Finding these kits in order to add a FireWire connection to a current  has become difficult. If modified with a kit, the deck name (as it appears in the Terminal, DVRescue and vrecord) might be different than the deck model. |
| [![Sony DSR-25](https://mipops.github.io/dvrescue/images/Sony_DSR-25.png){:width="300px"}](https://drive.google.com/file/d/1V2kIs3xO3ivmZgmT-Ul19vU3j-hjEdNM/view) | Sony | DSR-25 | DV; DVCAM | MiniDV; large/standard | LP | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1Nb9bckzMyLFrE8GH8MAFy8bzy8e1ITV4/view?usp=sharing) | [Link](https://drive.google.com/file/d/1tKwNSMazfd_WKAxjtylbH9V16WiBJJtk/view?usp=sharing) | AC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | no | Audio would have only been recorded on CH 1/2 (CH 3/4 is for dubbing only); no LOCAL/REMOTE switch |
| [![JVC BR-DV3000](https://mipops.github.io/dvrescue/images/JVC_BR-DV3000U.png){:width="300px"}](https://drive.google.com/file/d/10eiNO4V3K0kJh5G4abodIpeH-Zq-Kk_Z/view) | JVC | BR-DV3000 | DV; DVCAM | MiniDV; large/standard | LP; DVCPRO | NTSC/PAL | SP mode only | [Link](https://drive.google.com/file/d/1-zqvPw48WX9Rd9RwlyCySKDFRftUKMqN/view?usp=sharing) |  | DC IN 12V | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | DVCAM cassettes can be recorded in DV format. A tape recorded with the DVCAM format can be used only for playback for this VTR. | This VTR features dual support for NTSC and PAL. Certain functions however, are supported by only one signal system. They are indicated with (NTSC only) or (PAL only). |
| [![JVC BR-600/600UA](https://mipops.github.io/dvrescue/images/JVC_BR-DV6000.png){:width="300px"}](https://drive.google.com/file/d/1hwV4cXKTYx5cv_OxlIBUJo0ulKr2CxQ9/view) | JVC | BR-600/600UA | DV | MiniDV | DVCPRO; LP; PAL | NTSC | SP mode only | [Link](https://drive.google.com/file/d/1015dqIF6xvwYuhqcH_vuo9C6RsSFSlXE/view?usp=sharing) |  | DC IN 12V; AC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | yes | The AC and DC power supplies are switched automatically.  When the AC power supply is switched to the DC power supply, the power turns off.  When both power supplies are connected, the AC power supply has priority.  Be sure to confirm which power supply is in use when plugging or unplugging the power supply. | Has a LP lamp that will light up if a tape recorded in LP mode is inserted. |
| [![Panasonic AJ-D230H](https://mipops.github.io/dvrescue/images/Panasonic_AJ-D230.png){:width="300px"}](https://drive.google.com/file/d/10grx-0rtFvaFYtBj7DtvoShx8DlTThvi/view) | Panasonic | AJ-D230H |  | MiniDV/small (only with adapter); medium; standard/large |  |  | SP mode only | [Link](https://drive.google.com/file/d/10O3hBil3p9sz2XkVZq92jqOvi6idVc3U/view?usp=drive_link) |  | AC IN | Manual for the AJ-D230H/AJ-D230HP doesn't include a DV out in the scematic. However, that doesn't mean that mod weren't available at the time. Have a AJ-D230H/AJ-D230HP with a DV output? Let us know! | yes |
| [![Sony DSR-40](https://mipops.github.io/dvrescue/images/Sony_DSR-40P.png){:width="300px"}](https://drive.google.com/file/d/10daFniMX9mLhQXpGupuopyYNWkurZfad/view) | Sony | DSR-40 | DV/MiniDV; DVCAM | MiniDV; large/standard | DVCPRO; HDV; LP |  | SP mode only | [Link](https://archive.org/details/manualzilla-id-6976597) | [Link](https://archive.org/details/manual_DSR40P_SM_SONY) | AC IN | FireWire 400 4-Pin (IEEE 1394b 4-Pin) | no (RS-232C encoder only) |
| [![JVC BR-HD50/BR-HD50U](https://mipops.github.io/dvrescue/images/JVC_BR-HD50.png){:width="300px"}](https://drive.google.com/file/d/1ojiY8fS1Nlq_SyZvnMJiM5IBJtmTBtqz/view) | JVC | BR-HD50/BR-HD50U | DV; HDV; DVCAM (playback only) | MiniDV; large/standard | DVCPRO; LP |  | SP mode only | [Link](https://drive.google.com/file/d/10KqkTFabw0tOREvitjbSkPz_nCeFVzId/view?usp=sharing) |  | DC IN 12V | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes | Tapes recorded in the DVCAM format can only be played. | If the head is dusty, “HEAD CLEANING REQUIRED!” will be displayed on the monitor when this unit plays a tape. |
| [![Panasonic AJ-HD1400](https://mipops.github.io/dvrescue/images/Panasonic_AJ-HD1400.png){:width="300px"}](https://drive.google.com/file/d/10iI_X9WtP-2-j_hKh_Z63E1r63boBGwd/view) | Panasonic | AJ-HD1400 |  |  |  |  |  |  |  | AC IN | FireWire 400 6-Pin (IEEE 1394a 6-Pin) | yes |
