---
layout: post
title: DV Formats
---

# Historical Context
The DV format launched in 1995 as an affordable and compact digital videotape. Using digital videotape greatly simplified the production process compared to analog videotape; the ease-of-use, affordability, and compactness of DV enabled many communities within heritage, journalism, and the arts to integrate video into their culturally significant work. DV videotape was popular from the mid-1990’s through the late-2000’s when it was then superseded by born-digital video recordings. Preservation communities have developed expertise, tools, and best practices for both analog videotape and born-digital file-based audiovisual data; however digital videotape, which is data stored on a tape as a stream rather than as a file on a hard drive, falls in between these eras and the preservation of digital videotape has substantially less expertise, tools, or best practices to support its preservation. The advantages of DV videotape, such as cost, size, and simplicity, enabled many communities to start using video to document and to inform. DV videotape is extremely thin and fragile, highly sensitive to contaminants, and self-deteriorates at a rate far faster than chemically more simple and stable analog videotapes.

<iframe src="https://drive.google.com/file/d/1lxp3_LZrQEFtOyzypTf18joWfq6m28um/preview" width="640" height="480" allow="autoplay"></iframe>
&nbsp;

# Technical Specifics

The following resources provide detailed and illustrated overviews of DV format technical specifics including compression and the digital interface format:

* [DV Format Overview](https://web.archive.org/web/20110928040838/http://www.sony.ca/dvcam/pdfs/dvcam%20format%20overview.pdf) - Sony
* [DV, DVCAM & DVCPRO Formats](http://www.adamwilt.com/DV-FAQ-tech.html#DVchromakey) - Adam Wilt
* [DV Technical Details](http://www.adamwilt.com/DV-tech.html) - Adam Wilt 
* [DV-DIF (Digital Video Digital Interface Format)](https://web.archive.org/web/20100106092818/http://www.digitalpreservation.gov//formats/fdd/fdd000173.shtml) - Library of Congress
* [DV Format](https://web.archive.org/web/20100107032158/http://dvswitch.alioth.debian.org/wiki/DV_format/) - DV Switch 
* [Technical Papers on Digital Video (DV) and IEEE-1394 (a.k.a. FireWire)](http://web.archive.org/web/20041014025948/http://www.chumpchange.com/parkplace/Video/TechPapers.htm) - Roger Jennings
* [DVCPRO Formats](https://pro-av.panasonic.net/en/sales_o/02products/tapes/tapes.html) - Panasonic
* [DVCPRO50](https://www.broadcaststore.com/pdf/model/787287/B_AJ-HD1700.pdf) - Panasonic


# DV Formats

The DV tape family encompasses a variety of different subformats of various sizes and encodings. Ability to playback a particular tape will is dependent upon which tape sizes and formats your player supports.

## DV
<img alt="DV" src="{{ site.baseurl }}/images/DV+MiniDV_size-compare.png">
<details markdown=1>
  <summary markdown="span">Details</summary>

- Release Date: 1995
- AKA: MiniDV (for the small sized cassettes)
- Developing Manufacture: consortium of video camera manufacturers led by Sony and Panasonic
- Maximum Recording Capacity:
  - Small (MiniDV)
    - Standard Play (SP) - 66-80 minutes
    - Long Play (LP) -  132 minutes
  - Large (Standard)
    - Standard Play (SP) - 126-180 minutes
    - Long Play (LP) -  276 minutes
  - DVCAM 184 minute tape (can be recorded in DV at LP mode, but LP mode cannot be used for DVCAM formatting)
    - Standard Play (SP) - 276 minutes
    - Long Play (LP) - 414 minutes
- Size
  - Small (MiniDV) - 6.5 x 4.8 x 1.2 cm (see MiniDV for more details)
  - Large (Standard) - 12.5 x 7.8 x 1.5 cm
- Fun Facts/Tips
  - DV is an international standard created by a consortium of 10 companies for a consumer digital video format. The companies involved were Matsushita Electric Industrial Corp (Panasonic), Sony Corp, Victor Corporation of Japan (JVC), Philips Electronics, N.V., Sanyo Electric Co. Ltd, Hitachi, Ltd., Sharp Corporation,  Thompson Multimedia, Mitsubishi Electric Corporation, and Toshiba Corporation. 
  - DV tapes can be played back in both DVCAM and DVCPRO VCRs. Some DVPRO decks require an adapter to accommodate MiniDV, but Sony’s DSR-1500A, DSR-1000, and DSR-2000 all accept MiniDV without an adapter.
  - DV in LP mode will not play back in DVCAM or DVCPRO VTRs other than the DSR-2000
  - DV in SP mode (60-minute or shorter tapes) appears to be the universal tape format: it will play back in any of the VTRs.
  - An EP/LP tape can be FF/REW in a DVCAM, MiniDV or DVCPro deck, but cannot be played in a deck that isn’t compatible with EP/LP mode.
  - Most decks that cannot playback LP have a little EP or LP light that will flash or illuminate indicating it’s not compatible.
  - Uses the same codec as DV and was released the same year as the smaller sized cassette.
  - Most commonly used DV format.
  - DV tapes can be played back in both DVCAM and DVCPRO VCRs.
</details>


## DVCAM
<img alt="DVCAM" src="{{ site.baseurl }}/images/DVCAM_size-compare.png">
<details markdown=1>
  <summary markdown="span">Details</summary>

- Release Date: 1996
- Developing Manufacture: Sony
- Maximum Recording Capacity:
  - Small (MiniDV) - 40 minutes
  - Large (Standard) - 184 minutes
- Size
  - Small (MiniDV) - 6.5 x 4.8 x 1.2 cm (see MiniDV for more details)
  - Large (Standard) - 12.5 x 7.8 x 1.5 cm
- Fun Facts/Tips
  - DVCAM was Sony’s response to DVCPro and was advertised as being a professional grade format.
  - Uses locked audio, which prevents audio synchronization drift that may happen on DV if several generations of copies are made.
  - When recorded to tape, DVCAM uses 15 μm track pitch, which is 50% wider compared to baseline. Accordingly, tape is transported 50% faster, which reduces recording time by one third compared to regular DV. Because of the wider track and track pitch, DVCAM has the ability to do a frame-accurate insert edit, while regular DV may vary by a few frames on each edit compared to the preview.
  - With the exception of some newer (2001+) Panasonic and JVC machines, DVCAM does not play back on other manufacturer's DV equipment. Check the corresponding manual to find out if your machine will play back DVCAM.
  - DVCAM cannot record in LP mode.
</details>


## DVCPRO
<img alt="DVCPRO" src="{{ site.baseurl }}/images/DVCPro_size-compare.png">
<details markdown=1>
  <summary markdown="span">Details</summary>

- Release Date: 1995
- Developing Manufacture: Panasonic
- Maximum Recording Capacity:
  - Medium - 66 minutes
  - Large - 126
- Size
  - Medium - 9.7 x 6.36 x 1.4 cm
  - Large (Standard) - 12.4 x 7.6 x 1.4 cm
- Fun Facts/Tips
  - DVCPRO25 was an alternative name for the original DVCPRO.
  - Looks similar to other DVCPRO varieties, but is distinguishable by a yellow cassette door.
  - Philips, Ikegami, Hitachi also produced DVCPRO videotapes and equipment. For the most part, DVCPRO tapes need to be played in a deck manufactured by the same company as the tape.
  - DVCPRO VCRs can play both DV and DVCAM tapes but cannot record in these formats. MiniDV tapes can be played with an adaptor.
  - DVCPRO could not record in LP mode.
  - The Sony DSR-1500A deck will play back DVCPRO25 over 1394 as DVCPRO data, but is not compatible with other DVCPRO formats.
</details>


## DVCPRO50
<img alt="DVCPRO50" src="{{ site.baseurl }}/images/DVCPRO50.png">
<details markdown=1>
  <summary markdown="span">Details</summary>
  
- Release Date: 1997
- Developing Manufacture: Panasonic
- Maximum Recording Capacity:
  - Medium - 33 Minutes
  - Large (Standard) - 92 minutes
  - X-Large - 126 minutes
- Size
  - Medium - 9.7 x 6.36 x 1.4 cm
  - Large (Standard) - 12.4 x 7.6 x 1.4 cm
  - X-Large - 17.2 x 10.2 x 1.46 cm
- Fun Facts/Tips
  - Looks similar to other DVCPRO varieties, but is distinguishable by a blue cassette door.
  - DVCPRO50 offers two technical advantages over standard DVCPRO:
    - The bitrate is doubled to 50 Mbps
    - Color-sampling resolution is 4:2:2 instead of 4:1:1
  - The increased data rate means that recording time for DVCPRO50 is half that of standard DVCPRO.
  - DVCPRO50 is backwards-compatible with standard DVCPRO.
  - DVCPRO50 could not record in LP mode.
</details>


## DVCPROHD/DVCPRO100
<img alt="DVCPROHD" src="{{ site.baseurl }}/images/DVCPROHD_size-compare_NEW.png">
<details markdown=1>
  <summary markdown="span">Details</summary>
  
- Release Date: 2000
- Developing Manufacture: Panasonic
- Maximum Recording Capacity: 
  - Medium - 16.5 Minutes
  - Large - 64 minutes
  - X-Large - 126 minutes
- Size
  - Medium - 9.7 x 6.36 x 1.4 cm
  - Large (Standard) - 12.4 x 7.6 x 1.4 cm
  - X-Large - 17.2 x 10.2 x 1.46 cm
- Fun Facts/Tips
  - DVCPRO100 was an alternative name for DVCPROHD.
  - Looks similar to other DVCPRO varieties, but is distinguishable by a red cassette door.
  - DVCPROHD could be recorded in LP mode.
</details>


## HDV
<img alt="HDV" src="{{ site.baseurl }}/images/HDV+MiniDV_size-compare_NEW.png">
<details markdown=1>
  <summary markdown="span">Details</summary>

- Release Date: 2003
- Developing Manufacture: developed by JVC and supported by Sony, Canon, and Sharp
- Maximum Recording Capacity:
  - MiniDV - 63 minutes
  - Standard DVCAM - 184 minutes
  - HDV/DV-SP - 276 Minutes
- Size
  - Small - 6.5 x 4.8 x 1.2 cm
  - Large (Standard) - 12.5 x 7.8 x 1.5 cm
- Fun Facts/Tips
  - A HDV tape can be FF/REW in a DVCAM, MiniDV or DVCPro deck, but when in play mode, it will not play (no image or sound will playback and the counter will not move).
  - Only the HVR-S270 HDV camcorder was capable of recording onto full-size DV cassettes, but most HDV decks could accommodate both sizes for dubbing.
  - Generally, HDV devices are capable of playing and recording in DV format, though this is not required by HDV specification. Many HDV devices manufactured by Sony are capable of playing and recording in DVCAM format. 1080-line devices generally are not compatible with 720-line devices, though some standalone tape decks accept both HDV flavors. Devices that can play and record native 1080p video can play and record native 1080i video, however the opposite is not always the case.
  - HDV uses the same style tapes as DV, but uses MPEG-2 for compression, which transfers to a file with a MT2 wrapper (vs. a DV wrapper).
  - HDV can be recorded on any MiniDV tape.
</details>


## Digital8
<img alt="Digital8" src="{{ site.baseurl }}/images/Digital8.png">
<details markdown=1>
  <summary markdown="span">Details</summary>

- Release Date: 1999
- Developing Manufacture: Sony, Hitachi
- Maximum Recording Capacity: 60 minutes
- Size: 9.5 x 6.2 x 1.5 cm
- Fun Facts/Tips:
  - Uses the same digital encoding as MiniDV, but in a 8mm cassette (uses the same shell as Hi8 and Video8 videotape). For more information please see comparison descriptions from [Media College](https://www.mediacollege.com/video/format/compare/minidv-d8.html) and [Adam Wilt](http://www.adamwilt.com/DV-tech.html). 
  - An 8mm or Hi8 tape can be recorded in digital mode, but the 2 hour tapes can only store 1 hour of digital content.
  - Digital8 cannot record in LP mode.
  - Digital8 equipment records in DV format only, but usually can playback Video8 and Hi8 tapes as well. 
  - Also known as D8.
</details>
